//number of closest particles, that should be calculated
nClosest = 3;

selectImage("StackSegmented");	// selection of Stack with separated vesicles
run("Select All");	       		// selection of total picture to void potential selection of single vesicle
run("3D Manager");	       		// start 3d Manager (for continuous numbering after potential manual erasure of particles)	
Ext.Manager3D_AddImage();   	// add image
Ext.Manager3D_Count(nb);		// count number of particles
Ext.Manager3D_SelectFor(1,nb,1);//selection of all relevant particles (first registered particle is the seperating line and must be excluded) 
Ext.Manager3D_Measure();		// execution of measurement

// Save custom results table from 3D Manager and close
Ext.Manager3D_SaveResult("M",getDirectory("home")+"Results.csv");
Ext.Manager3D_CloseResult("M");

// Reimport results into regular Results table
lines=split(File.openAsString(getDirectory("home")+"M_Results.csv"), "\n");
labels=split(lines[0], "\t");
for (j=0; j<labels.length; j++)
    setResult(labels[j],0,0);
    run("Clear Results");
    for (i=1; i<lines.length; i++) {
        items=split(lines[i], "\t");
        for (j=0; j<items.length; j++)
            setResult(labels[j],i-1,items[j]);
     }
updateResults();
File.delete(getDirectory("home")+"M_Results.csv");

// create results header
head = "particle, Feret(nm), diameter_1(nm), diameter_2(nm), diameter_3(nm), volume(nm³)";
for (i=1; i<=nClosest; i++){
	head = head + ", closest"+i+", dist"+i+"(nm)"; // this part is dependend on the number of closest particles
}
print(head); //results header is written in Log file

//Measurements for each single particle is performed and illustrated
for(i=1;i<nb;i++) {
	Ext.Manager3D_Measure3D(i,"Vol",V); 		//measure volume
	
	Ext.Manager3D_GetName(i, name); 			//filter out label
	test = split(name, "-");

	Ext.Manager3D_Measure3D(i,"Feret",F);		// filter Feret diameter from results table

	EMaj=getResult("Ell_MajRad",i-1);	 		//filter second diameter diameter from results table
	
	Ext.Manager3D_Measure3D(i,"Elon1",Eelon);	//filter Elon from reults table
	
	Eelon = EMaj/Eelon*2; 						//is specified in relation to first diameter

	Ext.Manager3D_Measure3D(i,"Elon2",Eflat);	//analog to Eelon
	
	Eflat=EMaj/Eflat*2;

	// identification of n closest vesicles
	a = newArray();
	for (j=1; j<nb; j++){
		
			Ext.Manager3D_Dist2(i,j,"cc",dist); // all distances are calculated for the actual particle...
			a = Array.concat(a, dist);	    	// ...and saved in an array
	}

	sortedValues = Array.copy(a);				//values are copied in new array
	Array.sort(sortedValues);					//copied values are sorted
	rankPosArr = Array.rankPositions(a);		//ranking is determined, to match identifiers

	closest = "";
	for (jj = 1; jj <= nClosest; jj++){     	// the first n values of the sorted array and the matching identifiers are selected
		Ext.Manager3D_GetName(rankPosArr[jj]+1, name); 	//select identifier
		splitname = split(name, "-");				
		closest=closest+", "+splitname[1]+", "+sortedValues[jj];  //combine all data in one variable
	}
	
	EMaj=EMaj*2;								//doubling of values to calculate the diameter from the radius
	
	print(test[1]+", "+F+", "+EMaj+", "+Eelon+", "+Eflat+", "+V+""+closest); //output of all values in log window
}
Ext.Manager3D_Close();							//close 3D Manager

selectWindow("Results");						//close results window
run("Close");


names = newArray(nImages);						//close composit stack and and stack for 3d viewer
ids = newArray(nImages);
for (i=0; i < ids.length; i++){
        selectImage(i+1);
        ids[i] = getImageID();
        names[i] = getTitle();
} 

for (i=0; i < ids.length; i++){
        selectImage(ids[i]);
		if( names[i]=="StackSegmentedCopie"){
        	close();
        }
		else if( names[i]=="Composite"){
        	close();
        }
}



// again creation of composit to include changes from manual erasure of particles 
selectImage("StackSegmented");
run("Merge Channels...", "c1=StackDuplicateScale c2=StackSegmented create keep");

//again creation of stack for 3D viewer to include changes from manual erasure of particles
selectImage("StackSegmented");
run("Duplicate...", "title=StackSegmentedCopie duplicate range=1-"+nSlices);
selectImage("StackSegmentedCopie");
run("8-bit");
