macro "register Vesicles"{
getDimensions(width, height, channels, slices, frames)
pw = 0.574; ph = 0.574; dist = 0.574;

//Dialog.create("Scaling");
Dialog.create("Parameters");
Dialog.addNumber("pixel width in nm", pw);
Dialog.addNumber("pixel hight in nm", ph);
Dialog.addNumber("image distance in nm", dist);
Dialog.addMessage("");
Dialog.addNumber("Min. volume",3000);
Dialog.addNumber("Min. sphericity",0.5);
Dialog.addNumber("Max. elongation",2);
Dialog.show();
//user input of voxelsize in x, y and z dimensions
pw = Dialog.getNumber();
ph = Dialog.getNumber();
dist = Dialog.getNumber();
Vmin = Dialog.getNumber();
Smin = Dialog.getNumber();
elonmax = Dialog.getNumber();

//duplication of stack to make composit stack later
run("Duplicate...", "title=StackDuplicate duplicate range=1-"+nSlices); // copy "Stack" -> "StackDuplicate"
//scaling of StackDuplicate to 1nm/px
selectImage("StackDuplicate");
run("Scale...", "x="+pw+" y="+ph+" z=1 width="+width*pw+" height="+height*ph+" depth="+slices+" interpolation=Bilinear average process create title=StackDuplicateScale");
run("Properties...", "channels=1 slices="+slices+" frames=1 unit=nm pixel_width=1.0000 pixel_height=1.0000 voxel_depth="+dist);
run("Select All");		//selection of whole image, because the first steps of processing should work not only in the selected area 
run("8-bit");			//conversion in 16bit with 8bit intermediate stage, to prohibit conversion errors
run("16-bit");			//

//Gaussian filter to reduce image compression artefacts 
selectImage("StackDuplicate");
run("Gaussian Blur 3D...", "x=2.0 y=2.0 z=2.0");
//scaling of Stack to 1nm/px
run("Scale...", "x="+pw+" y="+ph+" z=1 width="+width*pw+" height="+height*ph+" depth="+slices+" interpolation=Bilinear average process create title=Stack");
run("Properties...", "channels=1 slices="+slices+" frames=1 unit=nm pixel_width=1.0000 pixel_height=1.0000 voxel_depth="+dist);

numROIs = 0;

while(numROIs < 2) {
	title = "Wait For Selection";  
	msg = "Please select the area you want to analyze\nin at least the first and last picture of\nthe image \"Stack\"and add the selection\nto the \"Roi-Manager\" by confirming\nthe selection with \"T\".\nAfterwards click \"OK\".";
	waitForUser(title, msg);
	numROIs = roiManager("count");
	if(numROIs < 2) {
		msg = "At least two selections are required!";
		waitForUser(title, msg);
	}
}

selectImage("Stack");	//image selection "Stack"
run("Select All");		//selection of entire picture, because the first steps of processing should happen not only in the selected area
run("8-bit");			//conversion in 16bit with intermediate state 8bit, because conversion errors may occure in some image types
run("16-bit");			//
run("Properties...", "channels=1 slices="+slices+" frames=1 unit=nm pixel_width=1.0000 pixel_height=1.0000 voxel_depth="+dist);

setForegroundColor(255, 255, 255); 	//definition of colours
setBackgroundColor(0, 0, 0);		//

run("Duplicate...", "title=StackCopie duplicate range=1-"+nSlices); //copying of "Stack" --> "StackCopie"
selectImage("Stack");	//selection of "Stack"

//Mean filter
//Gaussian filter and subsequent bilateral filter
run("Gaussian Blur 3D...", "x=3.4 y=3.4 z=3.4");
run("Mean...", "radius=3.45 stack");
run("Enhance Contrast...", "saturated=0.4");
run("8-bit");	//bilateral filter works only on 8bit images
run("Bilateral Filter", "spatial=3 range=100");
run("16-bit");

//contrast enhancement
run("Enhance Contrast...", "saturated=0.4 normalize process_all");

 	
//build threshold
run("Convert to Mask", "method=Mean background=Light calculate ");	//Threshold image through mean filtering


run("Dilate (3D)", "iso=255");										//areas that are higher than the threshold are slightly enlarged	

//delimit defined area
roiManager("Interpolate ROIs"); 									//initial area definition is interpolated for each picture by the methode "Interpolate Rois"
getDimensions( width, height, channels, slices, frames ); 			//areas outside of selection are filled with white colour to be excluded from analysis
for ( s=1; s<=slices; s++ ) {
   	Stack.setSlice( s );
   	roiManager("select", s-1);
   	setBackgroundColor(255, 255, 255);
   	roi = getInfo("selection.name");
   	if (roi==""){
  		fill(); 	
   	}
   	else{
   		run("Clear Outside", "slice");
   	}
}
run("Select All");
roiManager("Deselect");
roiManager("reset");

//fill small holes
run("Invert", "stack"); 	// inversion of colours in this stack
run("Analyze Particles...", "size=0-575 circularity=0.0-1.00 show=Nothing exclude add stack"); //registration of holes within a size of 0-500
roiManager("Fill");			// fill holes	
run("Invert", "stack");		// back conversion of colours
roiManager("reset"); 		// registered particles are deleted from RoiManager


// watershed algorithm, to seperate vesicles in 2d
run("Watershed", "stack");

//4x Erode to remove interfering components, thereby individual particles at the edge are shrinked
run("Erode", "stack");
run("Erode", "stack");
run("Erode", "stack");
run("Erode", "stack");

//removal of big particles (>6000)
run("Analyze Particles...", "size=6000-Infinity circularity=0.1-1.00 show=Nothing add stack");	//particle > 6000 are registered 
roiManager("Fill");					//registered particles are removed
roiManager("reset");				//registered particles are removes from RoiManager

//Watershed algorithmus in 3d, for seperation of still attached particles:

selectWindow("Stack-3.0-100.0");	// selection of "Stack-3.0-100.0"
rename("StackBinary");				//rename "Stack-3.0-100.0" -> "StackBinary", hence it is accepted as mask at the "3D Distance Map"
run("3D Distance Map", "map=EDT image=StackBinary mask=None threshold=1"); //calculates the distances to the center of the particles
selectWindow("EDT");

rename("EDT");	
run("Properties...", "channels=1 slices="+slices+" frames=1 unit=nm pixel_width=1.0000 pixel_height=1.0000 voxel_depth="+dist);			
run("Gaussian Blur 3D...", "x=3.45 y=3.45 z=3.45");	//smoothening of distance map

//close StackBinary
selectWindow("StackBinary");
close();

run("3D Watershed", "seeds_threshold=0 image_threshold=2 image=EDT seeds=Automatic radius=2.3"); //actual watershed algorithm for particle separation
setSlice(nSlices/2);						//image position in the stack is centered 
run("Enhance Contrast", "saturated=0.35");	//grey values are adjusted
run("3-3-2 RGB");							//colour model is changed from grey scale to multicoloured
rename("StackSegmented");					//stack with results is renamed into "StackSegmented"
run("Properties...", "channels=1 slices="+slices+" frames=1 unit=nm pixel_width=1.0000 pixel_height=1.0000 voxel_depth="+dist);

//registration of single vesicles in the 3D Manager
run("3D Manager Options", "volume surface compactness fit_ellipse geometric_invariants integrated_density mean_gray_value std_dev_gray_value feret minimum_gray_value maximum_gray_value centroid_(pix) centroid_(unit) distance_to_surface centre_of_mass_(pix) centre_of_mass_(unit) bounding_box radial_distance surface_contact closest distance_between_centers=10 distance_max_contact=1.80"); //mangager Optionen werden festgelegt
run("3D Manager"); 							//start 3d Manager

Ext.Manager3D_AddImage();					//"StackSegmented" is registered at the Manager
Ext.Manager3D_Count(nb);					//count number of registerd vesicles
Ext.Manager3D_SelectFor(1,nb,1);			//selection of relevant particles (the first registrated particle is the separation line and therefore has to be excluded) 


//deletion of particles, that should be excluded from analysis
for(i=1;i<nb;i++) {
	Ext.Manager3D_Select(i);						//selection of each particle
	
	Ext.Manager3D_Measure3D(i,"Elon2", Eflat);		//determination of variable Eflat (expansion in 3. level) 
	Ext.Manager3D_Measure3D(i,"Spher",S);			//determination of variable S (Spherizität) 
	Ext.Manager3D_Measure3D(i,"Vol",V);				//determination of variable V (Volumen) 

						
	if( V<Vmin*dist || Eflat>elonmax || S < Smin )		//deletion of selected particle, if one of the criterions is fulfilled
	{
		selectImage("StackSegmented");
		Ext.Manager3D_Select(i);
		Ext.Manager3D_FillStack(0, 0, 0);
	}
	else{
		//print("else   "+comp+" "+V+"  "+Eflat+" "+Rvolbox);
	}
}

Ext.Manager3D_Close(); // 3D Manager is closed

selectImage("StackSegmented");
//colours are adjusted
Stack.getStatistics(voxelCount, mean, min, max, stdDev)
//print(min+" "+max);
setMinAndMax(min, max);

//as an overview a composit image is created, where all selected particles are overlayed with the original stack
run("Merge Channels...", "c1=StackDuplicateScale c2=StackSegmented create keep");

//create copy of Stack -> "StackSegmentedCopie" and conversion to 8bit; this is important for the correct illustration of colours in the 3D Viewer 
selectImage("StackSegmented"); 
run("Duplicate...", "title=StackSegmentedCopie duplicate range=1-"+nSlices);
selectImage("StackSegmentedCopie");
run("Properties...", "channels=1 slices="+slices+" frames=1 unit=nm pixel_width=1.0000 pixel_height=1.0000 voxel_depth="+dist);
run("8-bit");

//close Roimanger
selectWindow("ROI Manager");
run("Close");

//close thresholded image
selectWindow("Stack");
close();

//close StackCopie
selectWindow("StackCopie");
close();

//close StackDuplicate
selectWindow("StackDuplicate");
close();

//close distance map (used by watershed algorithm)
selectWindow("EDT");
close();

//restart 3d Manager and add image for continuous numbering of objects
selectImage("StackSegmented");
run("3D Manager");
Ext.Manager3D_AddImage();
}