# enzyme correlation code written by liang, Oct. 2008,
# 
# methods: L-BFGS-B
# variables:
# S: stoich
# E: nullspace 
# w: weight factors
# z: enzyme expect. target 
 
estimate_enzyme_rates<-function(w,S,E,z) {
  distance=abs(E%*%w)-abs(z);
  distance[z==-1]=0;
  return (sqrt(t(distance)%*%distance));
}
 
library(car); library(MASS);
 
#go_enzy<-function() {
        pathfile="/home/als44eq/stuff/sfb630/gb-ap-238/R/staphylococcus/ser_pathways.sbml";
        nullfile="/home/als44eq/stuff/sfb630/gb-ap-238/R/staphylococcus/ser_null.sbml";
        stoifile="/home/als44eq/stuff/sfb630/gb-ap-238/R/staphylococcus/ser_stoich.sbml";
	enzyfile="/home/als44eq/stuff/sfb630/gb-ap-238/R/gb-ap-238_flux/ser_flux_ADDED_gbap_238_input.sbml";
 
        pathways=as.matrix(read.table(pathfile,sep=",",header=T,row.names=1));
        nullspace=as.matrix(read.table(nullfile,sep=",",header=T,row.names=1));
        stoichiometry=as.matrix(read.table(stoifile,sep=",",header=T,row.names=1));
        enzyme.expect=as.matrix(read.table(enzyfile,sep=",",header=T,row.names=1));
        print(enzyme.expect);        
 
        pathways.revc=pathways[,3];        
        pathways.revc[which(pathways.revc=="true")]=-100;
        pathways.revc[which(pathways.revc=="false")]=0;
        pathways.lower=as.numeric(pathways.revc);
 
        nullnorm=nullspace ;  #wrong: apply(nullspace,2,function(x){x/sqrt(x %*% x)});
        rownames(nullnorm)=rownames(nullspace);
 
        # cut the stoichiometry matrix
        #stoi.cut=stoichiometry[rownames(metabolite.expect),];
	stoi.cut=stoichiometry;
        nullnorm.cut=nullnorm;
 
        # Optimize the Constraint Linear Regression model of (Ew-y)'(Ew-y)
        optimum=optim(
	          rep(50,ncol(nullnorm)), function(X){return(estimate_enzyme_rates(X,stoi.cut,nullnorm.cut,enzyme.expect[,1]));},
        	  method="L-BFGS-B", lower=pathways.lower, upper=rep(100,ncol(nullnorm)), control=list(trace=1,maxit=10000)
        );	    
        act.estimate=optimum$par;       
	print(act.estimate); # models' activity
 
	result=nullnorm%*%act.estimate; fd=as.numeric(result); names(fd)=rownames(result); #print(fd);	        
	print(round(cbind(nullnorm%*%act.estimate,enzyme.expect[,1]),3)) ; 
	
	u<-enzyme.expect[,1];
	fd[u==-1]=NA;
	u[u==-1]=NA;
 
        layout(c(1,2));
	plot(abs(fd),abs(u),xlab="calculation",ylab="experiment",main="absolute value", pch=9);	
	fd_abso=abs(fd);
	u_abso=abs(u);
	#abline(lm(fd_abso~u_abso),lty=8,lwd=1,col="red");    
        plot(fd,u,pch=3,,xlab="calculation",ylab="experiment",main="raw value");
	t<-cbind(abs(fd),abs(u));
	
#} 
