/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf.actinactbf;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binarybf.treebf.TreeBooleanFunction;
import jimena.libs.MathLib;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class ActInactBooleanFunction
extends BinaryBooleanFunction {
    private static final long serialVersionUID = -1756565073860160320L;
    private boolean[] activators;
    private int numberOfActivators = -1;
    private TreeBooleanFunction treeBooleanFunction = null;

    public ActInactBooleanFunction(boolean[] activators) {
        if (activators == null) {
            throw new NullPointerException("Please provide an empty array to create the nullary constant false function.");
        }
        this.activators = activators;
    }

    @Override
    public boolean eval(boolean[] values) {
        boolean result = false;
        int i = 0;
        while (i < this.activators.length) {
            if (this.activators[i] && values[i]) {
                result = true;
                break;
            }
            ++i;
        }
        if (!result) {
            return false;
        }
        i = 0;
        while (i < this.activators.length) {
            if (!this.activators[i] && values[i]) {
                return false;
            }
            ++i;
        }
        return result;
    }

    @Override
    public int getArity() {
        return this.activators.length;
    }

    @Override
    public double interpolateSQUAD(double[] input, double[] squadWeights) throws BinaryBooleanFunction.InterpolationMethodNotSupported {
        if (input.length == 0) {
            return 0.0;
        }
        double result = 0.0;
        if (input.length == this.countActivators()) {
            double actsum = MathLib.dotProductUnchecked(this.activators, squadWeights, false);
            double actweight = MathLib.dotProductUnchecked(this.activators, squadWeights, input, false);
            result = (1.0 + actsum) / actsum * (actweight / (1.0 + actweight));
        } else if (input.length == this.countInactivators()) {
            double inactsum = MathLib.dotProductUnchecked(this.activators, squadWeights, true);
            double inactweight = MathLib.dotProductUnchecked(this.activators, squadWeights, input, true);
            result = 1.0 - (1.0 + inactsum) / inactsum * (inactweight / (1.0 + inactweight));
        } else {
            double actsum = MathLib.dotProductUnchecked(this.activators, squadWeights, false);
            double inactsum = MathLib.dotProductUnchecked(this.activators, squadWeights, true);
            double actweight = MathLib.dotProductUnchecked(this.activators, squadWeights, input, false);
            double inactweight = MathLib.dotProductUnchecked(this.activators, squadWeights, input, true);
            result = (1.0 + actsum) / actsum * (actweight / (1.0 + actweight));
            result *= 1.0 - (1.0 + inactsum) / inactsum * (inactweight / (1.0 + inactweight));
        }
        return result;
    }

    public int countActivators() {
        if (this.numberOfActivators == -1) {
            int counter = 0;
            int i = 0;
            while (i < this.getArity()) {
                if (this.activators[i]) {
                    ++counter;
                }
                ++i;
            }
            this.numberOfActivators = counter;
        }
        return this.numberOfActivators;
    }

    public int countInactivators() {
        return this.getArity() - this.countActivators();
    }

    @Override
    public double interpolateBooleCube(double[] input) {
        return this.getTreeBooleanFunction().interpolateBooleCube(input);
    }

    private TreeBooleanFunction getTreeBooleanFunction() {
        if (this.treeBooleanFunction == null) {
            this.treeBooleanFunction = new TreeBooleanFunction(this.activators);
        }
        return this.treeBooleanFunction;
    }

    @Override
    public ActInactBooleanFunction clone() {
        return new ActInactBooleanFunction((boolean[])this.activators.clone());
    }

    @Override
    protected BDD createBDDUnchecked(BDD[] inputs, BDDFactory bddFactory) {
        return this.getTreeBooleanFunction().createBDD(inputs, bddFactory);
    }

    @Override
    public String toString() {
        return this.getTreeBooleanFunction().toString();
    }
}

