/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.main;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.binaryrn.RegulatoryNetworkObserver;
import jimena.gui.charts.ChartsWindow;
import jimena.gui.guilib.TableFrame;
import jimena.gui.guilib.datatable.InputsTable;
import jimena.gui.guilib.datatable.NodesTable;
import jimena.gui.main.PanelGraphDrawer;
import jimena.libs.ArrayLib;
import jimena.libs.MathLib;
import jimena.libs.StandardNumberFormat;
import jimena.perturbation.PerturbationsWindow;
import jimena.settings.SettingsWindow;
import jimena.simulation.ProgressWindow;
import jimena.simulationmethods.ARBNMethod;
import jimena.simulationmethods.BooleCubeMethod;
import jimena.simulationmethods.CRBNMethod;
import jimena.simulationmethods.DARBNMethod;
import jimena.simulationmethods.HillCubeMethod;
import jimena.simulationmethods.NormalizedHillCubeMethod;
import jimena.simulationmethods.SQUADMethod;
import jimena.simulationmethods.SimulationMethod;
import jimena.ssssearcher.RandomSearcher;

public class Main
extends JFrame
implements RegulatoryNetworkObserver {
    private static final long serialVersionUID = -5355497689587430613L;
    private final double MINDT = 1.0E-7;
    private final double MINMAXT = 1.0E-4;
    private final double MINSPEED = 1.0E-4;
    private Preferences preferences = Preferences.userNodeForPackage(this.getClass());
    private SimulationMethod[] simulationMethods = new SimulationMethod[]{new BooleCubeMethod(), new ARBNMethod(), new CRBNMethod(), new DARBNMethod(), new HillCubeMethod(), new NormalizedHillCubeMethod(), new SQUADMethod()};
    private RegulatoryNetwork network = new RegulatoryNetwork();
    private File currentFile;
    private InputsTable inputsFrame = new InputsTable(this.network);
    private NodesTable nodesFrame = new NodesTable(this.network);
    private PerturbationsWindow perturbationFrame = new PerturbationsWindow(this.network);
    private ChartsWindow chartsFrame = new ChartsWindow(this.network);
    private SettingsWindow settingsFrame = new SettingsWindow();
    private JPanel panelGraph;
    private JComboBox<SimulationMethod> comboMethods;
    private JTextField textDt;
    private JTextField textmaxt;
    private JTextField textMaxSpeed;
    private JMenuItem menuFile1 = new JMenuItem(this.preferences.get("file1", ""));
    private JMenuItem menuFile2 = new JMenuItem(this.preferences.get("file2", ""));
    private JMenuItem menuFile3 = new JMenuItem(this.preferences.get("file3", ""));
    private JMenuItem menuFile4 = new JMenuItem(this.preferences.get("file4", ""));
    private FileFilter graphmlFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().matches(".*\\.graphml$") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "yEd GraphML-files (*.graphml)";
        }
    };
    private FileFilter jimenaFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().matches(".*\\.jimena$") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "Jimena-files (*.jimena)";
        }
    };

    private String getFileExtension(File file) {
        String name = file.getName();
        int dot = name.lastIndexOf(".");
        return name.substring(dot + 1);
    }

    public void loadFile(File file) {
        if (this.getFileExtension(file).equalsIgnoreCase("graphml")) {
            try {
                this.network.loadYEdFile(file);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "GraphML Loading Failed", 0);
            }
        } else if (this.getFileExtension(file).equalsIgnoreCase("jimena")) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                RegulatoryNetwork storedNetwork = (RegulatoryNetwork)objectInputStream.readObject();
                this.network.loadNetwork(storedNetwork);
                objectInputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Jimena Loading Failed", 0);
            }
        }
        this.currentFile = file;
        this.refreshTitle();
        this.relayoutWindows();
        this.addToLastUsed(file);
    }

    public Main() {
        super("Jimena");
        this.setIconImage(new ImageIcon("images" + File.separator + "chart16.png").getImage());
        this.setMinimumSize(new Dimension(700, 450));
        this.setDefaultCloseOperation(3);
        this.getContentPane().setLayout(new BorderLayout());
        this.network.addObserver(this);
        this.setJMenuBar(this.createMenubar());
        this.getContentPane().add((Component)this.createToolBar(), "First");
        this.panelGraph = new PanelGraphDrawer(this.network, this.nodesFrame, this.chartsFrame);
        JScrollPane scrollPaneGraph = new JScrollPane(this.panelGraph);
        scrollPaneGraph.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                Main.this.panelGraph.repaint();
            }
        });
        this.getContentPane().add((Component)scrollPaneGraph, "Center");
        this.setVisible(true);
        this.relayoutWindows();
    }

    private JMenuBar createMenubar() {
        JMenuBar menubar = new JMenuBar();
        JMenu menuNetwork = new JMenu("Network");
        menuNetwork.setMnemonic(78);
        menubar.add(menuNetwork);
        JMenuItem menuLoad = new JMenuItem("Load Simulation", new ImageIcon("images" + File.separator + "openfile16.png"));
        menuLoad.setMnemonic(76);
        menuLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser filechooser = new JFileChooser();
                FileFilter[] fileFilterArray = filechooser.getChoosableFileFilters();
                int n = fileFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FileFilter filter = fileFilterArray[n2];
                    filechooser.removeChoosableFileFilter(filter);
                    ++n2;
                }
                filechooser.addChoosableFileFilter(Main.this.jimenaFilter);
                filechooser.setDialogTitle("Open Jimena-File");
                filechooser.setDialogType(0);
                int returnVal = filechooser.showOpenDialog(Main.this);
                if (returnVal == 0) {
                    Main.this.loadFile(filechooser.getSelectedFile());
                }
            }
        });
        menuNetwork.add(menuLoad);
        JMenuItem menuOpen = new JMenuItem("Import yED File", new ImageIcon("images" + File.separator + "openfile16.png"));
        menuOpen.setMnemonic(79);
        menuOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JFileChooser filechooser = new JFileChooser();
                FileFilter[] fileFilterArray = filechooser.getChoosableFileFilters();
                int n = fileFilterArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FileFilter filter = fileFilterArray[n2];
                    filechooser.removeChoosableFileFilter(filter);
                    ++n2;
                }
                filechooser.addChoosableFileFilter(Main.this.graphmlFilter);
                filechooser.setDialogTitle("Open a yEd GraphML-file");
                filechooser.setDialogType(0);
                int returnVal = filechooser.showOpenDialog(Main.this);
                if (returnVal == 0) {
                    Main.this.loadFile(filechooser.getSelectedFile());
                }
            }
        });
        menuNetwork.add(menuOpen);
        JMenuItem menuReload = new JMenuItem("Reload", new ImageIcon("images" + File.separator + "refresh16.png")){
            private static final long serialVersionUID = -730380585179996276L;

            @Override
            protected void paintComponent(Graphics g) {
                this.setEnabled(Main.this.currentFile != null);
                super.paintComponent(g);
            }
        };
        menuReload.setMnemonic(82);
        menuReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Main.this.loadFile(Main.this.currentFile);
                Main.this.relayoutWindows();
            }
        });
        menuNetwork.add(menuReload);
        JMenuItem menuSave = new JMenuItem("Save Simulation", new ImageIcon("images" + File.separator + "save16.png")){
            private static final long serialVersionUID = -730380585179996276L;

            @Override
            protected void paintComponent(Graphics g) {
                this.setEnabled(Main.this.currentFile != null);
                super.paintComponent(g);
            }
        };
        menuSave.setMnemonic(83);
        menuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    JFileChooser filechooser = new JFileChooser();
                    FileFilter[] fileFilterArray = filechooser.getChoosableFileFilters();
                    int n = fileFilterArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FileFilter filter = fileFilterArray[n2];
                        filechooser.removeChoosableFileFilter(filter);
                        ++n2;
                    }
                    filechooser.addChoosableFileFilter(Main.this.jimenaFilter);
                    filechooser.setDialogTitle("Save to Jimena-File");
                    filechooser.setDialogType(1);
                    int returnVal = filechooser.showSaveDialog(Main.this);
                    if (returnVal == 0) {
                        File file = filechooser.getSelectedFile();
                        if (!Main.this.jimenaFilter.accept(filechooser.getSelectedFile())) {
                            file = new File(String.valueOf(file.toString()) + ".jimena");
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(file);
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
                        objectOutputStream.writeObject(Main.this.network);
                        objectOutputStream.close();
                    }
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Saving failed", 0);
                }
            }
        });
        menuNetwork.add(menuSave);
        menuNetwork.addSeparator();
        this.refreshLastUsedFiles();
        this.menuFile1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.loadFile(new File(Main.this.preferences.get("file1", "")));
            }
        });
        menuNetwork.add(this.menuFile1);
        this.menuFile2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.loadFile(new File(Main.this.preferences.get("file2", "")));
            }
        });
        menuNetwork.add(this.menuFile2);
        this.menuFile3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.loadFile(new File(Main.this.preferences.get("file3", "")));
            }
        });
        menuNetwork.add(this.menuFile3);
        this.menuFile4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.loadFile(new File(Main.this.preferences.get("file4", "")));
            }
        });
        menuNetwork.add(this.menuFile4);
        menuNetwork.addSeparator();
        JMenuItem menuClose = new JMenuItem("Exit", new ImageIcon("images" + File.separator + "exit16.png"));
        menuClose.setMnemonic(69);
        menuClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                System.exit(0);
            }
        });
        menuNetwork.add(menuClose);
        JMenu menuView = new JMenu("View");
        menuView.setMnemonic(86);
        menubar.add(menuView);
        menuView.add(new ToggleWindowMenuEntry(this.nodesFrame, "Nodes Table"));
        menuView.add(new ToggleWindowMenuEntry(this.inputsFrame, "Inputs Table"));
        menuView.add(new ToggleWindowMenuEntry(this.perturbationFrame, "Perturbations Table"));
        menuView.add(new ToggleWindowMenuEntry(this.chartsFrame, "Charts Window/Data Export"));
        menuView.add(new ToggleWindowMenuEntry(this.settingsFrame, "Settings Window"));
        menuView.addSeparator();
        JMenuItem menuShowAllWindows = new JMenuItem("Show All Windows", new ImageIcon("images" + File.separator + "defaultwindows16.png"));
        menuShowAllWindows.setMnemonic(83);
        menuShowAllWindows.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Frame[] frameArray = Frame.getFrames();
                int n = frameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Frame f = frameArray[n2];
                    f.setVisible(true);
                    ++n2;
                }
            }
        });
        menuView.add(menuShowAllWindows);
        JMenu menuAnalysis = new JMenu("Analysis");
        menuAnalysis.setMnemonic(65);
        menubar.add(menuAnalysis);
        JMenuItem menuRandomValues = new JMenuItem("Random Values");
        menuRandomValues.setIcon(new ImageIcon("images" + File.separator + "random16.png"));
        menuRandomValues.setMnemonic(82);
        menuRandomValues.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Main.this.network.setValues(MathLib.randomVector(Main.this.network.getNetworkNodes().length));
                if (!Main.this.getMethod().isContinuous()) {
                    Main.this.network.makeDiscrete();
                }
                Main.this.network.notifyObserversOfChangedValues();
            }
        });
        menuAnalysis.add(menuRandomValues);
        JMenuItem menuSteadyState = new JMenuItem("Find Stable State From Current State");
        menuSteadyState.setIcon(new ImageIcon("images" + File.separator + "simulatetime16.png"));
        menuSteadyState.setMnemonic(70);
        menuSteadyState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new SSSFromCurrentValuesThread().start();
            }
        });
        menuAnalysis.add(menuSteadyState);
        menuAnalysis.addSeparator();
        JMenuItem menuSteadyStates = new JMenuItem("Find Stable States");
        menuSteadyStates.setIcon(new ImageIcon("images" + File.separator + "table16.png"));
        menuSteadyStates.setMnemonic(65);
        menuSteadyStates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new FindSSSThread().start();
            }
        });
        menuAnalysis.add(menuSteadyStates);
        JMenuItem menuDiscreteStableSteadyStates = new JMenuItem("Discrete Stable States");
        menuDiscreteStableSteadyStates.setIcon(new ImageIcon("images" + File.separator + "table16.png"));
        menuDiscreteStableSteadyStates.setMnemonic(68);
        menuDiscreteStableSteadyStates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new DiscreteSSSThread().start();
            }
        });
        menuAnalysis.add(menuDiscreteStableSteadyStates);
        JMenu menuHelp = new JMenu("Help");
        menuHelp.setMnemonic(72);
        menubar.add(menuHelp);
        JMenuItem menuGuiTutorial = new JMenuItem("GUI tutorial", new ImageIcon("images" + File.separator + "help16.png"));
        menuGuiTutorial.setMnemonic(71);
        menuGuiTutorial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        JOptionPane.showMessageDialog(Main.this, "Your internet browser could not be started automatically.\n\n Please open the web page http://stefan-karl.de/jimena/guitutorial.html", "Internet browser could not be started", 1);
                        return;
                    }
                    Desktop.getDesktop().browse(new URI("http://stefan-karl.de/jimena/guitutorial.html"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        });
        menuHelp.add(menuGuiTutorial);
        menuHelp.addSeparator();
        JMenuItem menuAbout = new JMenuItem("About Jimena", new ImageIcon("images" + File.separator + "about16.png"));
        menuAbout.setMnemonic(65);
        menuAbout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                JOptionPane.showMessageDialog(Main.this, "Jimena is developed by\n\nStefan Karl\nDepartment of Bioinformatics, University of W\u00fcrzburg\nstefan[dot]karl[at]uni-wuerzburg[dot]de\n\nThe project is supervised by Thomas Dandekar, head of the Department of Bioinformatics\n\nAcknowledgements:\nJavaBDD (GNU LGPL) by John Whaley (http://javabdd.sourceforge.net) is used as a BDD framework\nIcons (GNU LPGL) by Oxygen Team (http://www.iconarchive.com/artist/oxygen-icons.org.html)", "About Jimena", 0, new ImageIcon("images" + File.separator + "chart72.png"));
            }
        });
        menuHelp.add(menuAbout);
        return menubar;
    }

    private void refreshTitle() {
        String fileName = this.currentFile != null ? this.currentFile.getName() : "No File Loaded";
        this.setTitle("Jimena - " + fileName + " - Time: " + StandardNumberFormat.NUMBERFORMAT.format(this.network.getTimeIndex().getValue()));
    }

    private JToolBar createToolBar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setLayout(new FlowLayout(0));
        toolbar.setRollover(true);
        toolbar.setPreferredSize(new Dimension(80, 33));
        toolbar.setFloatable(false);
        JLabel labelMethod = new JLabel("Simulation Method:");
        toolbar.add(labelMethod);
        this.comboMethods = new JComboBox();
        SimulationMethod[] simulationMethodArray = this.simulationMethods;
        int n = this.simulationMethods.length;
        int n2 = 0;
        while (n2 < n) {
            SimulationMethod method = simulationMethodArray[n2];
            this.comboMethods.addItem(method);
            ++n2;
        }
        this.comboMethods.setToolTipText("If you chose a discrete simulation method Simulated Time/dt steps will be simulated");
        this.comboMethods.setFocusable(false);
        toolbar.add(this.comboMethods);
        JLabel labelMaxt = new JLabel("Simulated Time: ");
        toolbar.add(labelMaxt);
        this.textmaxt = new JFormattedTextField(StandardNumberFormat.NUMBERFORMAT);
        this.textmaxt.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                try {
                    if (Double.valueOf(Main.this.textmaxt.getText()) < 1.0E-4) {
                        Main.this.textmaxt.setText(String.valueOf(1.0E-4));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.textmaxt.setToolTipText("This limit applies to the time in the simulation, not the time of the calculation.");
        this.textmaxt.setText("50");
        this.textmaxt.setPreferredSize(new Dimension(40, 20));
        toolbar.add(this.textmaxt);
        JLabel labelDt = new JLabel("dt: ");
        toolbar.add(labelDt);
        this.textDt = new JFormattedTextField(StandardNumberFormat.NUMBERFORMAT);
        this.textDt.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                try {
                    if (Double.valueOf(Main.this.textDt.getText()) < 1.0E-7) {
                        Main.this.textDt.setText(String.valueOf(1.0E-7));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.textDt.setText("0.01");
        this.textDt.setPreferredSize(new Dimension(80, 20));
        toolbar.add(this.textDt);
        JLabel labelMaxSpeed = new JLabel("Max Speed: ");
        toolbar.add(labelMaxSpeed);
        this.textMaxSpeed = new JFormattedTextField(StandardNumberFormat.NUMBERFORMAT);
        this.textMaxSpeed.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent arg0) {
                try {
                    if (Double.valueOf(Main.this.textMaxSpeed.getText()) < 1.0E-4 && Double.valueOf(Main.this.textMaxSpeed.getText()) != 0.0) {
                        Main.this.textMaxSpeed.setText(String.valueOf(1.0E-4));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        this.textMaxSpeed.setToolTipText("Enter '0' for unlimited speed.");
        this.textMaxSpeed.setText("1");
        this.textMaxSpeed.setPreferredSize(new Dimension(60, 20));
        toolbar.add(this.textMaxSpeed);
        JButton buttonSingleStep = new JButton(new ImageIcon("images" + File.separator + "singlestep16.png"));
        buttonSingleStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SimulateThread(true).start();
            }
        });
        buttonSingleStep.setFocusable(true);
        buttonSingleStep.setBorderPainted(false);
        buttonSingleStep.setToolTipText("Single Step");
        toolbar.add(buttonSingleStep);
        JButton buttonSimulate = new JButton(new ImageIcon("images" + File.separator + "simulatetime16.png"));
        buttonSimulate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new SimulateThread(false).start();
            }
        });
        buttonSimulate.setFocusable(true);
        buttonSimulate.setBorderPainted(false);
        buttonSimulate.setToolTipText("Simulate");
        toolbar.add(buttonSimulate);
        JButton buttonReset = new JButton(new ImageIcon("images" + File.separator + "revert16.png"));
        buttonReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Main.this.network.reset();
            }
        });
        buttonReset.setFocusable(true);
        buttonReset.setBorderPainted(false);
        buttonReset.setToolTipText("Reset Simulation");
        toolbar.add(buttonReset);
        return toolbar;
    }

    private double getDt() {
        return Double.valueOf(this.textDt.getText());
    }

    private double getMaxt() {
        return Double.valueOf(this.textmaxt.getText());
    }

    private double getMaxSpeed() {
        double maxSpeed = Double.valueOf(this.textMaxSpeed.getText());
        if (maxSpeed == 0.0) {
            maxSpeed = Double.MAX_VALUE;
        }
        return maxSpeed;
    }

    private SimulationMethod getMethod() {
        return (SimulationMethod)this.comboMethods.getSelectedItem();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Startup failed", 0);
            System.exit(0);
        }
        Locale.setDefault(Locale.US);
        new Main();
    }

    public void relayoutWindows() {
        this.pack();
        int curX = (int)this.getLocation().getX();
        int curY = (int)this.getLocation().getY();
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame f = frameArray[n2];
            if (f != this) {
                f.setLocation(curX += 20, curY += 20);
            }
            ++n2;
        }
    }

    public void lockGUI() {
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame f = frameArray[n2];
            Main.recursiveSetEnabled(f, false);
            ++n2;
        }
    }

    private static void recursiveSetEnabled(Container c, boolean value) {
        Component[] componentArray = c.getComponents();
        int n = componentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Component cc = componentArray[n2];
            cc.setEnabled(value);
            if (cc instanceof Container && ((Container)cc).getComponents().length != 0) {
                Main.recursiveSetEnabled((Container)cc, value);
            }
            ++n2;
        }
    }

    public void unlockGUI() {
        Frame[] frameArray = Frame.getFrames();
        int n = frameArray.length;
        int n2 = 0;
        while (n2 < n) {
            Frame f = frameArray[n2];
            Main.recursiveSetEnabled(f, true);
            ++n2;
        }
    }

    private void addToLastUsed(File file) {
        if (!this.preferences.get("file1", "").equals(file.getPath())) {
            if (this.preferences.get("file2", "").equals(file.getPath())) {
                this.preferences.put("file2", this.preferences.get("file1", ""));
                this.preferences.put("file1", file.getPath());
            } else if (this.preferences.get("file3", "").equals(file.getPath())) {
                this.preferences.put("file3", this.preferences.get("file2", ""));
                this.preferences.put("file2", this.preferences.get("file1", ""));
                this.preferences.put("file1", file.getPath());
            } else {
                this.preferences.put("file4", this.preferences.get("file3", ""));
                this.preferences.put("file3", this.preferences.get("file2", ""));
                this.preferences.put("file2", this.preferences.get("file1", ""));
                this.preferences.put("file1", file.getPath());
            }
        }
        this.refreshLastUsedFiles();
    }

    private void refreshLastUsedFiles() {
        this.menuFile1.setText("1 " + new File(this.preferences.get("file1", "")).getName());
        this.menuFile1.setVisible(!this.preferences.get("file1", "").equals(""));
        this.menuFile2.setText("2 " + new File(this.preferences.get("file2", "")).getName());
        this.menuFile2.setVisible(!this.preferences.get("file2", "").equals(""));
        this.menuFile3.setText("3 " + new File(this.preferences.get("file3", "")).getName());
        this.menuFile3.setVisible(!this.preferences.get("file3", "").equals(""));
        this.menuFile4.setText("4 " + new File(this.preferences.get("file4", "")).getName());
        this.menuFile4.setVisible(!this.preferences.get("file4", "").equals(""));
    }

    @Override
    public void notifyNetworkChanged() {
        this.notifyValuesChanged();
    }

    @Override
    public void notifyValuesChanged() {
        this.refreshTitle();
    }

    private abstract class Calculation
    extends Thread {
        private Calculation() {
        }

        @Override
        public final void run() {
            Main.this.lockGUI();
            if (Main.this.network.nodeCount() != 0) {
                this.doCalculation();
            } else {
                JOptionPane.showMessageDialog(null, "No nodes in the network.", "Search failed", 0);
            }
            Main.this.unlockGUI();
        }

        abstract void doCalculation();
    }

    private class DiscreteSSSThread
    extends Calculation {
        private DiscreteSSSThread() {
        }

        @Override
        void doCalculation() {
            new TableFrame(Main.this, "Discrete Stable States", ArrayLib.bytesListToObjectsListUnchecked(Main.this.network.discreteStableSteadyStates()), Main.this.network.getNodeNames(), Byte.class, null).setVisible(true);
        }
    }

    private class FindSSSThread
    extends Calculation {
        private FindSSSThread() {
        }

        @Override
        void doCalculation() {
            String s = (String)JOptionPane.showInputDialog(Main.this, "Number of seconds to search", "Maximum Calculation Time", 3, null, null, "10");
            if (s == null) {
                return;
            }
            int maxTime = 0;
            try {
                maxTime = Integer.valueOf(s);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(null, "Please enter a number", "Input Invalid", 0);
                return;
            }
            ArrayList<double[]> result = Main.this.network.stableSteadyStates(SettingsWindow.MAXSTABILITYDIFFERENCE.getValue(), SettingsWindow.MINSTABILITYTIME.getValue(), Main.this.getMethod(), Main.this.getDt(), Main.this.getMaxt(), SettingsWindow.MAXDUPLICATEDIFFERENCE.getValue(), maxTime * 1000, new ProgressWindow(), SettingsWindow.THREADS.getValue(), new RandomSearcher());
            if (result != null) {
                new TableFrame(Main.this, "Stable States", ArrayLib.doublesListToObjectsListUnchecked(result), Main.this.network.getNodeNames(), Double.class, null).setVisible(true);
            }
        }
    }

    private class SSSFromCurrentValuesThread
    extends Calculation {
        private SSSFromCurrentValuesThread() {
        }

        @Override
        void doCalculation() {
            double[] stableSteadyState = Main.this.network.stableSteadyState(Main.this.network.getValues(), SettingsWindow.MAXSTABILITYDIFFERENCE.getValue(), SettingsWindow.MINSTABILITYTIME.getValue(), Main.this.getMethod(), Main.this.getDt(), Main.this.getMaxt(), new ProgressWindow());
            if (stableSteadyState != null) {
                ArrayList<double[]> resultAsList = new ArrayList<double[]>();
                resultAsList.add(stableSteadyState);
                new TableFrame(Main.this, "Discrete Stable States", ArrayLib.doublesListToObjectsListUnchecked(resultAsList), Main.this.network.getNodeNames(), Double.class, null).setVisible(true);
            } else {
                JOptionPane.showMessageDialog(null, "The simulation did not converge in the specified time.", "Simulation Did Not Converge", 1);
            }
        }
    }

    private class SimulateThread
    extends Calculation {
        boolean singleStep;

        public SimulateThread(boolean singleStep) {
            this.singleStep = singleStep;
        }

        @Override
        void doCalculation() {
            Main.this.network.simulate(Main.this.getMethod(), Main.this.getDt(), this.singleStep ? Main.this.getDt() : Main.this.getMaxt(), Main.this.getMaxSpeed(), SettingsWindow.MINSIMULATIONTIMEBETWEENLOGS.getValue(), new ProgressWindow());
        }
    }

    private class ToggleWindowMenuEntry
    extends JCheckBoxMenuItem {
        private static final long serialVersionUID = -52102852821756779L;
        private JFrame frame;

        public ToggleWindowMenuEntry(JFrame frame, String menuCaption) {
            super(menuCaption);
            this.frame = frame;
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    ToggleWindowMenuEntry.this.frame.setVisible(!ToggleWindowMenuEntry.this.frame.isVisible());
                }
            });
        }

        @Override
        public boolean isSelected() {
            if (this.frame == null) {
                return false;
            }
            return this.frame.isVisible();
        }
    }
}

