/*
 * Decompiled with CFR 0.152.
 */
package jimena.perturbation;

import java.util.TreeMap;
import javax.swing.table.AbstractTableModel;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.binaryrn.RegulatoryNetworkObserver;
import jimena.perturbation.Perturbation;

public class PerturbationsModel
extends AbstractTableModel
implements RegulatoryNetworkObserver {
    private static final long serialVersionUID = -3638671347217871959L;
    private RegulatoryNetwork network;
    private TreeMap<Integer, Integer> mapRowToNode;
    private TreeMap<Integer, Integer> mapRowToPerturbation;

    public PerturbationsModel(RegulatoryNetwork network) {
        this.network = network;
        network.addObserver(this);
        this.notifyNetworkChanged();
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.mapRowToNode.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return String.valueOf(this.nodeToPerturbation(row).getName()) + ": " + this.rowToPerturbation(row).getDescription();
    }

    @Override
    public void notifyNetworkChanged() {
        this.notifyValuesChanged();
    }

    @Override
    public void notifyValuesChanged() {
        this.mapRowToNode = new TreeMap();
        this.mapRowToPerturbation = new TreeMap();
        int rowIndex = 0;
        int nodeIndex = 0;
        NetworkNode[] networkNodeArray = this.network.getNetworkNodes();
        int n = networkNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            int perturbationIndex = 0;
            for (Perturbation perturbation : node.getPerturbations()) {
                this.mapRowToNode.put(rowIndex, nodeIndex);
                this.mapRowToPerturbation.put(rowIndex, perturbationIndex);
                ++rowIndex;
                ++perturbationIndex;
            }
            ++nodeIndex;
            ++n2;
        }
        this.fireTableStructureChanged();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void deletePerturbation(int row) {
        this.nodeToPerturbation(row).getPerturbations().remove(this.mapRowToPerturbation.get(row));
        this.network.notifyObserversOfChangedNetwork();
    }

    public Perturbation rowToPerturbation(int row) {
        return this.network.getNetworkNodes()[this.mapRowToNode.get(row)].getPerturbations().get(this.mapRowToPerturbation.get(row));
    }

    public NetworkNode nodeToPerturbation(int row) {
        return this.network.getNetworkNodes()[this.mapRowToNode.get(row)];
    }
}

