/*
 * Decompiled with CFR 0.152.
 */
package jimena.settings;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import jimena.libs.MathLib;
import jimena.settings.AbstractSetting;
import jimena.settings.RawSetting;

public class IntegerSetting
extends AbstractSetting<Integer> {
    private RawSetting.SettingsTextField settingsTextField = new IntegerSettingsTextField();

    public IntegerSetting(String key, String label, String description, int minValue, int maxValue, int defaultValue) {
        super(key, label, description, minValue, maxValue, defaultValue);
        MathLib.checkWithinRange(defaultValue, minValue, maxValue);
    }

    @Override
    public Integer getValue() {
        return preferences.getInt(this.getKey(), (Integer)this.defaultValue);
    }

    @Override
    public JTextField getTextField() {
        return this.settingsTextField;
    }

    @Override
    public void reset() {
        this.settingsTextField.reset();
    }

    public class IntegerSettingsTextField
    extends RawSetting.SettingsTextField {
        private static final long serialVersionUID = 2600825281394479832L;

        public IntegerSettingsTextField() {
            this.setText(String.valueOf(IntegerSetting.this.getValue()));
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    try {
                        if (Integer.valueOf(IntegerSettingsTextField.this.getText()) < (Integer)((IntegerSettingsTextField)IntegerSettingsTextField.this).IntegerSetting.this.minValue) {
                            IntegerSettingsTextField.this.setText(String.valueOf(((IntegerSettingsTextField)IntegerSettingsTextField.this).IntegerSetting.this.minValue));
                        }
                        if (Integer.valueOf(IntegerSettingsTextField.this.getText()) > (Integer)((IntegerSettingsTextField)IntegerSettingsTextField.this).IntegerSetting.this.maxValue) {
                            IntegerSettingsTextField.this.setText(String.valueOf(((IntegerSettingsTextField)IntegerSettingsTextField.this).IntegerSetting.this.maxValue));
                        }
                    }
                    catch (NumberFormatException e) {
                        IntegerSettingsTextField.this.setText(String.valueOf(((IntegerSettingsTextField)IntegerSettingsTextField.this).IntegerSetting.this.defaultValue));
                    }
                    preferences.putInt(IntegerSetting.this.getKey(), Integer.valueOf(IntegerSettingsTextField.this.getText()));
                }
            });
        }

        @Override
        public void reset() {
            this.setText(String.valueOf(IntegerSetting.this.defaultValue));
            preferences.putInt(IntegerSetting.this.getKey(), Integer.valueOf(this.getText()));
        }
    }
}

