/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulation;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import jimena.simulation.CalculationController;

public class ProgressWindow
extends JDialog
implements CalculationController {
    private static final long serialVersionUID = 2463655132948378857L;
    private JProgressBar progressbar;
    private JButton abortButton;
    private long creationTime = System.currentTimeMillis();
    private static final String titleStart = "Calculation running - ";
    private boolean isOn = true;

    public ProgressWindow() {
        super((Frame)null, "Calculation running", false);
        this.setLayout(new FlowLayout());
        this.progressbar = new JProgressBar(0, 0, 10000);
        this.progressbar.setPreferredSize(new Dimension(400, 30));
        this.add(this.progressbar);
        this.abortButton = new JButton("Abort Calculation", new ImageIcon("images\\stop32.png"));
        this.abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ProgressWindow.this.isOn = false;
                ProgressWindow.this.setVisible(false);
            }
        });
        this.add(this.abortButton);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent arg0) {
                ProgressWindow.this.isOn = false;
            }
        });
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void setProgress(double progress, int stepsDone) {
        this.progressbar.setValue((int)(progress * 10000.0));
        long now = System.currentTimeMillis();
        long secondLeft = (long)((1.0 - progress) / progress * (double)(now - this.creationTime) / 1000.0);
        String durationLeft = String.format("%d:%02d:%02d", secondLeft / 3600L, secondLeft % 3600L / 60L, secondLeft % 60L);
        int stepsPerSec = (int)((double)stepsDone * 1000.0 / (double)(now - this.creationTime));
        this.setTitle(titleStart + (int)(progress * 100.0) + "% - Time left: " + durationLeft + " - " + stepsPerSec + "/s");
    }

    @Override
    public boolean isOn() {
        return this.isOn;
    }

    @Override
    public void notifyCalculationFinished() {
        this.setVisible(false);
    }
}

