/*
 * Decompiled with CFR 0.152.
 */
package jimena.binaryrn;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.TreeSet;
import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.Input;
import jimena.libs.DoubleValue;
import jimena.libs.MathLib;
import jimena.perturbation.Perturbation;

public class NetworkNode
implements Serializable {
    private static final long serialVersionUID = -759500325019694525L;
    private String name;
    private double value;
    private double odefyDecay = 1.0;
    private double squadDecay = 1.0;
    private double squadSteepness = 10.0;
    private BinaryBooleanFunction function;
    private Input[] inputs;
    private Rectangle2D.Double rectangle;
    private boolean hillNormalize = true;
    private double[] hillNs;
    private double[] hillKs;
    private double[] squadWeights;
    private double initialValue;
    private LinkedList<Perturbation> perturbations = new LinkedList();
    private DoubleValue timeIndex;
    private ArrayList<Point2D.Double> log = new ArrayList();

    protected void log() {
        this.log.add(new Point2D.Double(this.timeIndex.getValue(), this.getValue()));
    }

    protected void resetLog() {
        this.log = new ArrayList();
    }

    public ArrayList<Point2D.Double> getLog() {
        return this.log;
    }

    public double[] getSQUADWeights() {
        return this.squadWeights;
    }

    private void setSQUADWeights(double[] squadWeights) {
        if (squadWeights == null) {
            throw new NullPointerException();
        }
        if (squadWeights.length != this.squadWeights.length) {
            throw new IllegalArgumentException("The number of SQUAD weigts to set must match the number of inputs to the node.");
        }
        double[] dArray = squadWeights;
        int n = squadWeights.length;
        int n2 = 0;
        while (n2 < n) {
            double weight = dArray[n2];
            if (weight <= 0.0) {
                throw new IllegalArgumentException("The SQUAD weight must be greater than 0.");
            }
            ++n2;
        }
        this.squadWeights = squadWeights;
    }

    public double[] getHillNs() {
        return this.hillNs;
    }

    public double[] getHillKs() {
        return this.hillKs;
    }

    public NetworkNode(String name, double value, double odefyDecay, double squadDecay, double squadSteepness, BinaryBooleanFunction function, Input[] inputs, Rectangle2D.Double rectangle, boolean hillNormalize, double[] hillNs, double[] hillKs, double[] squadWeights, double initialValue, LinkedList<Perturbation> perturbations, DoubleValue timeIndex, ArrayList<Point2D.Double> log) {
        this(name, function, inputs, rectangle, initialValue, timeIndex);
        this.setValue(MathLib.limitToRangeAndAssertNumerical(value, 0.0, 1.0));
        this.odefyDecay = MathLib.limitToRangeAndAssertNumerical(odefyDecay, 0.0, Double.MAX_VALUE);
        this.squadDecay = MathLib.limitToRangeAndAssertNumerical(squadDecay, 0.0, Double.MAX_VALUE);
        this.squadSteepness = MathLib.limitToRangeAndAssertNumerical(squadSteepness, 0.0, Double.MAX_VALUE);
        this.hillNormalize = hillNormalize;
        if (hillNs == null || hillKs == null || perturbations == null || log == null) {
            throw new NullPointerException();
        }
        if (hillNs.length != inputs.length || hillKs.length != inputs.length) {
            throw new IllegalArgumentException("The number of parameters must match the number of inputs.");
        }
        this.hillNs = hillNs;
        this.hillKs = hillKs;
        this.setSQUADWeights(squadWeights);
        this.perturbations = perturbations;
        this.log = log;
    }

    public NetworkNode(String name, BinaryBooleanFunction function, Input[] inputs, Rectangle2D.Double rectangle, double initialValue, DoubleValue timeIndex) {
        if (name == null || function == null || inputs == null || rectangle == null || timeIndex == null) {
            throw new NullPointerException();
        }
        Input[] inputArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            Input i = inputArray[n2];
            if (i == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
        if (function.getArity() != inputs.length) {
            throw new IllegalArgumentException("Arity of the function must correspond to the number of inputs.");
        }
        this.name = name;
        this.function = function;
        this.inputs = inputs;
        this.rectangle = rectangle;
        this.initialValue = MathLib.limitToRangeAndAssertNumerical(initialValue, 0.0, 1.0);
        this.setValue(initialValue);
        this.timeIndex = timeIndex;
        this.squadWeights = new double[inputs.length];
        this.hillNs = new double[inputs.length];
        this.hillKs = new double[inputs.length];
        int i = 0;
        while (i < inputs.length) {
            this.squadWeights[i] = 1.0;
            this.hillNs[i] = 2.0;
            this.hillKs[i] = 0.5;
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public Rectangle2D.Double getRectangle() {
        return this.rectangle;
    }

    public BinaryBooleanFunction getFunction() {
        return this.function;
    }

    public Input[] getInputs() {
        return this.inputs;
    }

    public double getOdefyDecay() {
        return this.odefyDecay;
    }

    public void setOdefyDecay(double odefyDecay) {
        this.odefyDecay = odefyDecay;
    }

    public double getSQUADSteepness() {
        return this.squadSteepness;
    }

    public void setSQUADSteepness(double squadSteepness) {
        this.squadSteepness = squadSteepness;
    }

    public double getSQUADDecay() {
        return this.squadDecay;
    }

    public void setSQUADDecay(double squadDecay) {
        this.squadDecay = squadDecay;
    }

    public boolean getHillNormalize() {
        return this.hillNormalize;
    }

    public void setHillNormalize(boolean hillNormalize) {
        this.hillNormalize = hillNormalize;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public double getValue() {
        return this.applyPerturbations(this.value, this.timeIndex.getValue());
    }

    public double applyPerturbations(double value, double t) {
        if (this.perturbations.size() == 0) {
            return value;
        }
        double pertubationsValue = this.getPerturbationsValue(t);
        if (MathLib.isNaN(pertubationsValue)) {
            return value;
        }
        return pertubationsValue;
    }

    public void setValue(Double value) {
        this.value = MathLib.limitToRangeAndAssertNumerical(value, 0.0, 1.0);
    }

    private double getPerturbationsValue(double t) {
        int active = 0;
        double sum = 0.0;
        for (Perturbation perturbation : this.perturbations) {
            double value = perturbation.getValue(t);
            if (value < 0.0) continue;
            sum += value;
            ++active;
        }
        if (active == 0) {
            return Double.NaN;
        }
        return sum / (double)active;
    }

    public LinkedList<Perturbation> getPerturbations() {
        return this.perturbations;
    }

    public void reset() {
        this.setValue(this.initialValue);
        this.resetLog();
    }

    public String toString() {
        return this.name;
    }

    public NetworkNode clone(DoubleValue timeIndex, boolean includeLogs) {
        Input[] copiedInputs = new Input[this.inputs.length];
        int i = 0;
        while (i < this.inputs.length) {
            copiedInputs[i] = this.inputs[i].clone();
            ++i;
        }
        LinkedList<Perturbation> copiedPerturbations = new LinkedList<Perturbation>();
        for (Perturbation perturbation : this.perturbations) {
            copiedPerturbations.add(perturbation.clone());
        }
        ArrayList<Point2D.Double> copiedLog = new ArrayList<Point2D.Double>();
        if (includeLogs) {
            for (Point2D.Double logEntry : this.log) {
                copiedLog.add((Point2D.Double)logEntry.clone());
            }
        }
        return new NetworkNode(this.name, this.value, this.odefyDecay, this.squadDecay, this.squadSteepness, this.function.clone(), copiedInputs, (Rectangle2D.Double)this.rectangle.clone(), this.hillNormalize, (double[])this.hillNs.clone(), (double[])this.hillKs.clone(), this.squadWeights, this.initialValue, copiedPerturbations, timeIndex.clone(), copiedLog);
    }

    public TreeSet<Integer> getInputSources() {
        TreeSet<Integer> result = new TreeSet<Integer>();
        Input[] inputArray = this.inputs;
        int n = this.inputs.length;
        int n2 = 0;
        while (n2 < n) {
            Input input = inputArray[n2];
            result.add(input.getSource());
            ++n2;
        }
        return result;
    }

    public void makeDiscrete() {
        this.value = this.value < 0.5 ? 0.0 : 1.0;
    }
}

