/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulation;

import javax.swing.JOptionPane;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.libs.ChecksLib;
import jimena.simulation.CalculationController;
import jimena.simulationmethods.SimulationMethod;

public class Simulator
extends Thread {
    private double minSimulationTimeBetweenLogs;
    private static final double minTimeBetweenNotifications = 50.0;
    private RegulatoryNetwork network;
    private SimulationMethod method;
    private double dt;
    private double maxt;
    private double maxSpeed;
    private CalculationController calculationController;

    public Simulator(RegulatoryNetwork network, SimulationMethod method, double dt, double maxt, double maxSpeed, double minSimulationTimeBetweenLogs, CalculationController calculationController) {
        ChecksLib.checkNotNull(network, method);
        if (dt <= 0.0 || maxt < 0.0 || maxSpeed <= 0.0 || minSimulationTimeBetweenLogs <= 0.0) {
            throw new IllegalArgumentException("All numerical inputs to the constuctor of a Simulator must positive.");
        }
        this.network = network;
        this.method = method;
        this.dt = dt;
        this.maxt = maxt;
        this.maxSpeed = maxSpeed;
        this.minSimulationTimeBetweenLogs = minSimulationTimeBetweenLogs;
        this.calculationController = calculationController;
    }

    @Override
    public void run() {
        if (this.network.nodeCount() != 0) {
            try {
                double t = 0.0;
                long lastNotification = System.currentTimeMillis();
                int stepsDone = 0;
                int stepsPerLap = (int)(this.maxSpeed * 50.0 / this.dt / 1000.0);
                int stepsDoneAtLastNotification = 0;
                double timeIndexAtLastLog = 0.0;
                while (t + this.dt < this.maxt + this.dt / 10.0 && (this.calculationController == null || this.calculationController.isOn())) {
                    if (stepsDone - stepsDoneAtLastNotification <= stepsPerLap) {
                        this.method.stepUpdateNetwork(this.network, this.dt);
                        t += this.dt;
                        ++stepsDone;
                    } else {
                        Thread.sleep(1L);
                    }
                    if ((double)(System.currentTimeMillis() - lastNotification) >= 50.0) {
                        stepsDoneAtLastNotification = stepsDone;
                        if (this.calculationController != null) {
                            this.calculationController.setProgress(t / this.maxt, stepsDone);
                        }
                        this.network.notifyObserversOfChangedValues();
                        lastNotification = System.currentTimeMillis();
                    }
                    if (!(this.network.getTimeIndex().getValue() - timeIndexAtLastLog >= this.minSimulationTimeBetweenLogs)) continue;
                    this.network.log();
                    timeIndexAtLastLog = this.network.getTimeIndex().getValue();
                }
                this.network.notifyObserversOfChangedValues();
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Simulation failed", 0);
            }
            if (this.calculationController != null) {
                this.calculationController.notifyCalculationFinished();
            }
        }
    }
}

