/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulationmethods;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.simulationmethods.ContinuousSimulationMethod;

public class SQUADMethod
extends ContinuousSimulationMethod {
    @Override
    public double getDerivativeValue(RegulatoryNetwork network, int nodeIndex, double[] values) {
        NetworkNode node = network.getNetworkNodes()[nodeIndex];
        BinaryBooleanFunction function = node.getFunction();
        double interpol = function.interpolateSQUAD(this.getInputs(network, nodeIndex, values), node.getSQUADWeights());
        double h = network.getNetworkNodes()[nodeIndex].getSQUADSteepness();
        double g = network.getNetworkNodes()[nodeIndex].getSQUADDecay();
        double e1 = Math.exp(0.5 * h);
        double e2 = Math.exp(-h * (interpol - 0.5));
        return (-e1 + e2) / ((1.0 - e1) * (1.0 + e2)) - g * values[nodeIndex];
    }

    @Override
    public String toString() {
        return "SQUAD";
    }
}

