/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf.treebf;

import java.util.LinkedList;
import jimena.binarybf.treebf.TreeNode;

public abstract class BinaryNode
extends TreeNode {
    private static final long serialVersionUID = -3569782960854244159L;
    protected TreeNode leaf1;
    protected TreeNode leaf2;

    public BinaryNode(TreeNode leaf1, TreeNode leaf2) {
        if (leaf1 == null || leaf2 == null) {
            throw new NullPointerException();
        }
        this.leaf1 = leaf1;
        this.leaf2 = leaf2;
        if (this.isCyclic()) {
            throw new IllegalArgumentException("The tree of a boolean function must be a acyclic.");
        }
    }

    @Override
    public double interpolateBooleCube(double[] inputs) {
        double result = 0.0;
        double result1 = this.leaf1.interpolateBooleCube(inputs);
        double result2 = this.leaf2.interpolateBooleCube(inputs);
        if (this.evalNode(false, false)) {
            result += (1.0 - result1) * (1.0 - result2);
        }
        if (this.evalNode(false, true)) {
            result += (1.0 - result1) * result2;
        }
        if (this.evalNode(true, false)) {
            result += result1 * (1.0 - result2);
        }
        if (this.evalNode(true, true)) {
            result += result1 * result2;
        }
        return result;
    }

    @Override
    public boolean eval(boolean[] inputs) {
        return this.evalNode(this.leaf1.eval(inputs), this.leaf2.eval(inputs));
    }

    protected abstract boolean evalNode(boolean var1, boolean var2);

    @Override
    public int getMinArity() {
        return Math.max(this.leaf1.getMinArity(), this.leaf2.getMinArity());
    }

    @Override
    protected boolean isCyclic(LinkedList<TreeNode> predecessors) {
        if (predecessors.contains(this)) {
            return true;
        }
        predecessors.add(this);
        boolean result = this.leaf1.isCyclic(predecessors) || this.leaf2.isCyclic(predecessors);
        predecessors.removeLast();
        return result;
    }
}

