/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf.treebf;

import java.util.LinkedList;
import jimena.binarybf.treebf.TreeNode;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class NotNode
extends TreeNode {
    private static final long serialVersionUID = 18801225881561981L;
    private TreeNode leaf;

    public NotNode(TreeNode leaf) {
        if (leaf == null) {
            throw new NullPointerException();
        }
        this.leaf = leaf;
        if (this.isCyclic()) {
            throw new IllegalArgumentException("The tree of a boolean function must be a acyclic.");
        }
    }

    @Override
    public double interpolateBooleCube(double[] inputs) {
        return 1.0 - this.leaf.interpolateBooleCube(inputs);
    }

    @Override
    public boolean eval(boolean[] inputs) {
        return !this.leaf.eval(inputs);
    }

    @Override
    public int getMinArity() {
        return this.leaf.getMinArity();
    }

    @Override
    protected boolean isCyclic(LinkedList<TreeNode> predecessors) {
        if (predecessors.contains(this)) {
            return true;
        }
        predecessors.add(this);
        boolean result = this.leaf.isCyclic(predecessors);
        predecessors.removeLast();
        return result;
    }

    @Override
    public NotNode clone() {
        return new NotNode(this.leaf.clone());
    }

    @Override
    protected BDD createBDD(BDD[] inputs, BDDFactory bddFactory) {
        return this.leaf.createBDD(inputs, bddFactory).not();
    }

    @Override
    public String toString() {
        return "(NOT " + this.leaf.toString() + ")";
    }
}

