/*
 * Decompiled with CFR 0.152.
 */
package jimena.binaryrn;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.TreeSet;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetworkLib;
import jimena.binaryrn.RegulatoryNetworkObserver;
import jimena.libs.DoubleValue;
import jimena.libs.MathLib;
import jimena.libs.StandardNumberFormat;
import jimena.libs.StringLib;
import jimena.simulation.CalculationController;
import jimena.simulation.SSSFromStartVector;
import jimena.simulation.SimulatedAnnealingSSS;
import jimena.simulation.Simulator;
import jimena.simulation.StableSteadyState;
import jimena.simulationmethods.SimulationMethod;
import jimena.ssssearcher.SSSSearcher;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.JFactory;

public class RegulatoryNetwork
implements Serializable {
    private static final long serialVersionUID = -3637940236128103506L;
    private NetworkNode[] networkNodes = new NetworkNode[0];
    private transient HashSet<RegulatoryNetworkObserver> observers = new HashSet();
    private DoubleValue timeIndex = new DoubleValue(0.0);
    private static final int BDDPRESETS = 1000000;

    private static void checkParameters(double stabilityMaxDiff, double stabilityMinTime, int simulationsPerInput, SimulationMethod method, double dt, double maxt) {
        if (stabilityMaxDiff < 0.0 || stabilityMinTime <= 0.0 || simulationsPerInput <= 0 || dt <= 0.0 || maxt <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (method == null) {
            throw new NullPointerException();
        }
    }

    public RegulatoryNetwork() {
    }

    public RegulatoryNetwork(NetworkNode[] networkNodes, DoubleValue timeIndex) {
        if (networkNodes == null || timeIndex == null) {
            throw new NullPointerException();
        }
        this.networkNodes = networkNodes;
        this.observers = new HashSet();
        this.timeIndex = timeIndex;
    }

    public void addObserver(RegulatoryNetworkObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers.add(observer);
    }

    public SSSFromStartVector annealingStableSteadyStateSearcher(double[] startValues, SimulationMethod method, long maxt) {
        double[] dArray = startValues;
        int n = startValues.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            MathLib.checkNotNaNAndWithinRange(value, 0.0, 1.0);
            ++n2;
        }
        if (method == null) {
            throw new NullPointerException();
        }
        if (maxt <= 0L) {
            throw new IllegalArgumentException();
        }
        RegulatoryNetwork searchingNetwork = this.cloneWithoutObserversAndLogAndANewTimeIndex();
        searchingNetwork.setValues(startValues);
        SimulatedAnnealingSSS stableSteadyState = new SimulatedAnnealingSSS(searchingNetwork, method, maxt);
        return stableSteadyState;
    }

    public RegulatoryNetwork cloneWithoutObserversAndLogAndANewTimeIndex() {
        DoubleValue timeIndex = new DoubleValue(0.0);
        NetworkNode[] copiedNetworkNodes = new NetworkNode[this.nodeCount()];
        int i = 0;
        while (i < copiedNetworkNodes.length) {
            copiedNetworkNodes[i] = this.networkNodes[i].clone(timeIndex, false);
            ++i;
        }
        return new RegulatoryNetwork(copiedNetworkNodes, timeIndex);
    }

    public double cycleIndex(int node, boolean favorSmallCycles) {
        if (node < 0 || node > this.networkNodes.length) {
            throw new IllegalArgumentException("The specified node does not exist in the network.");
        }
        LinkedList<Integer> visitedNodes = new LinkedList<Integer>();
        visitedNodes.add(node);
        return this.cycleIndex(visitedNodes, node, favorSmallCycles);
    }

    private double cycleIndex(LinkedList<Integer> visitedNodes, int node, boolean favorSmallCycles) {
        double result = 0.0;
        for (Integer source : this.networkNodes[node].getInputSources()) {
            if (visitedNodes.peekFirst() == source) {
                if (favorSmallCycles) {
                    result += 1.0 / Math.pow(2.0, visitedNodes.size());
                    continue;
                }
                result += 1.0;
                continue;
            }
            if (visitedNodes.contains(source)) continue;
            visitedNodes.add(source);
            result += this.cycleIndex(visitedNodes, source, favorSmallCycles);
            visitedNodes.removeLast();
        }
        return result;
    }

    public ArrayList<byte[]> discreteStableSteadyStates() {
        BDDFactory bddFactory = JFactory.init(1000000, 1000000);
        bddFactory.setVarNum(this.nodeCount());
        BDD[] nodes = new BDD[this.nodeCount()];
        int i = 0;
        while (i < this.nodeCount()) {
            nodes[i] = bddFactory.ithVar(i);
            ++i;
        }
        BDD network = bddFactory.one();
        int i2 = 0;
        while (i2 < this.nodeCount()) {
            BDD[] inputs = new BDD[this.networkNodes[i2].getInputs().length];
            int j = 0;
            while (j < this.networkNodes[i2].getInputs().length) {
                inputs[j] = nodes[this.networkNodes[i2].getInputs()[j].getSource()];
                ++j;
            }
            BDD functionBDD = this.networkNodes[i2].getFunction().createBDD(inputs, bddFactory);
            functionBDD = nodes[i2].biimp(functionBDD);
            network.andWith(functionBDD);
            ++i2;
        }
        return MathLib.bddAllsatResultToArray(network.allsat());
    }

    public TreeSet<Integer> getInputIndicesByName(int node, String name) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node was not found in the network.");
        }
        if (name == null) {
            throw new NullPointerException();
        }
        TreeSet<Integer> result = new TreeSet<Integer>();
        int i = 0;
        while (i < this.networkNodes[node].getInputs().length) {
            if (StringLib.equalsTrimmed(this.getInputSourceName(node, i), name)) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    public TreeSet<Integer> getInputIndicesByName(String node, String input) {
        return this.getInputIndicesByName(this.getNodeIndexByName(node), input);
    }

    public String getInputSourceName(int node, int index) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node was not found in the network.");
        }
        if (node < 0 || index >= this.networkNodes[node].getInputs().length) {
            throw new IllegalArgumentException("The specified input was not found in the node.");
        }
        return this.networkNodes[this.networkNodes[node].getInputs()[index].getSource()].getName();
    }

    public NetworkNode[] getNetworkNodes() {
        return this.networkNodes;
    }

    public NetworkNode getNodeByName(String name) {
        return this.networkNodes[this.getNodeIndexByName(name)];
    }

    public int getNodeIndexByName(String name) {
        int i = 0;
        while (i < this.networkNodes.length) {
            if (StringLib.equalsTrimmed(this.networkNodes[i].getName(), name)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Node not found.");
    }

    public String[] getNodeNames() {
        String[] names = new String[this.nodeCount()];
        int i = 0;
        while (i < this.nodeCount()) {
            names[i] = this.networkNodes[i].getName();
            ++i;
        }
        return names;
    }

    public HashSet<RegulatoryNetworkObserver> getObservers() {
        return this.observers;
    }

    public DoubleValue getTimeIndex() {
        return this.timeIndex;
    }

    public double[] getValues() {
        double[] result = new double[this.nodeCount()];
        int i = 0;
        while (i < this.nodeCount()) {
            result[i] = this.networkNodes[i].getValue();
            ++i;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.nodeCount() == 0;
    }

    public void loadNetwork(RegulatoryNetwork storedNetwork) {
        this.networkNodes = storedNetwork.getNetworkNodes();
        this.timeIndex = storedNetwork.getTimeIndex();
        this.notifyObserversOfChangedNetwork();
    }

    public void loadYEdFile(File file) {
        this.timeIndex = new DoubleValue(0.0);
        try {
            this.networkNodes = RegulatoryNetworkLib.parseYEdFile(file, this.timeIndex);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.notifyObserversOfChangedNetwork();
    }

    public void log() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.log();
            ++n2;
        }
    }

    public void makeDiscrete() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.makeDiscrete();
            ++n2;
        }
    }

    public int nodeCount() {
        return this.networkNodes.length;
    }

    public void notifyObserversOfChangedNetwork() {
        for (RegulatoryNetworkObserver observer : this.observers) {
            observer.notifyNetworkChanged();
        }
    }

    public void notifyObserversOfChangedValues() {
        for (RegulatoryNetworkObserver observer : this.observers) {
            observer.notifyValuesChanged();
        }
    }

    public void removeAllPerturbations() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.getPerturbations().clear();
            ++n2;
        }
    }

    public void removeObserver(RegulatoryNetworkObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers.remove(observer);
    }

    public void reset() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.reset();
            node.resetLog();
            ++n2;
        }
        this.timeIndex.setValue(0.0);
        this.notifyObserversOfChangedValues();
    }

    public void setObservers(HashSet<RegulatoryNetworkObserver> observers) {
        if (observers == null) {
            throw new NullPointerException();
        }
        this.observers = observers;
    }

    public void setValues(double[] values) {
        int i = 0;
        while (i < values.length) {
            this.networkNodes[i].setValue(values[i]);
            ++i;
        }
    }

    public void simulate(SimulationMethod method, double dt, double maxt, double maxSpeed, double minSimulationTimeBetweenLogs, CalculationController calculationController) {
        Simulator simulator = new Simulator(this, method, dt, maxt, maxSpeed, minSimulationTimeBetweenLogs, calculationController);
        simulator.start();
        try {
            simulator.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public double[] stableSteadyState(double[] startValues, double stabilityMaxDiff, double stabilityMinTime, SimulationMethod method, double dt, double maxt, CalculationController calculationController) {
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, 1, method, dt, maxt);
        double[] dArray = startValues;
        int n = startValues.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            MathLib.checkNotNaNAndWithinRange(value, 0.0, 1.0);
            ++n2;
        }
        StableSteadyState stableSteadyState = this.stableSteadyStateSearcher(startValues, stabilityMaxDiff, stabilityMinTime, method, dt, maxt, calculationController);
        stableSteadyState.start();
        try {
            stableSteadyState.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return stableSteadyState.getResult();
    }

    public ArrayList<double[]> stableSteadyStates(double stabilityMaxDiff, double stabilityMinTime, SimulationMethod method, double dt, double maxt, double duplicateMaxDiff, long maxTime, CalculationController calculationController, int threads, SSSSearcher sssSearcher) {
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, 1, method, dt, maxt);
        if (duplicateMaxDiff < 0.0 || maxTime <= 0L) {
            throw new IllegalArgumentException();
        }
        return sssSearcher.searchSSStates(this, maxTime, method, dt, maxt, stabilityMaxDiff, stabilityMinTime, duplicateMaxDiff, calculationController, threads);
    }

    public StableSteadyState stableSteadyStateSearcher(double[] startValues, double stabilityMaxDiff, double stabilityMinTime, SimulationMethod method, double dt, double maxt, CalculationController calculationController) {
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, 1, method, dt, maxt);
        double[] dArray = startValues;
        int n = startValues.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            MathLib.checkNotNaNAndWithinRange(value, 0.0, 1.0);
            ++n2;
        }
        RegulatoryNetwork searchingNetwork = this.cloneWithoutObserversAndLogAndANewTimeIndex();
        searchingNetwork.setValues(startValues);
        StableSteadyState stableSteadyState = new StableSteadyState(searchingNetwork, method, dt, maxt, stabilityMaxDiff, stabilityMinTime, calculationController);
        return stableSteadyState;
    }

    public int sumOfInputs() {
        int numberOfInputs = 0;
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            numberOfInputs += node.getInputs().length;
            ++n2;
        }
        return numberOfInputs;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        double[] dArray = this.getValues();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double o = dArray[n2];
            result.append(String.valueOf(StandardNumberFormat.SHORTFIXEDNUMBERFORMAT.format(o)) + " | ");
            ++n2;
        }
        return result.toString();
    }
}

