/*
 * Decompiled with CFR 0.152.
 */
package jimena.libs;

import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MathLib {
    public static ArrayList<byte[]> bddAllsatResultToArray(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException();
        }
        Object object = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = object[n2];
            if (b > 1 || b < -1) {
                throw new IllegalArgumentException("The input is not a valid bdd allsat result.");
            }
            ++n2;
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        result.add(new byte[bytes.length]);
        int i = 0;
        while (i < bytes.length) {
            if (bytes[i] != -1) {
                object = result.iterator();
                while (object.hasNext()) {
                    byte[] resultBytes = (byte[])object.next();
                    resultBytes[i] = bytes[i];
                }
            } else {
                int oldSize = result.size();
                int j = 0;
                while (j < oldSize) {
                    result.add((byte[])result.get(j).clone());
                    ++j;
                }
                j = result.size() / 2;
                while (j < result.size()) {
                    result.get((int)j)[i] = 1;
                    ++j;
                }
            }
            ++i;
        }
        return result;
    }

    public static ArrayList<byte[]> bddAllsatResultToArray(List<byte[]> list) {
        if (list == null) {
            throw new NullPointerException();
        }
        Iterator<byte[]> iterator = list.iterator();
        while (iterator.hasNext()) {
            byte[] bytes;
            byte[] byArray = bytes = iterator.next();
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                if (b > 1 || b < -1) {
                    throw new IllegalArgumentException("The input are not valid bdd allsat results.");
                }
                ++n2;
            }
        }
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (byte[] solution : list) {
            result.addAll(MathLib.bddAllsatResultToArray(solution));
        }
        return result;
    }

    public static double meanSquaredDifferenceUnchecked(double[] array1, double[] array2) {
        return MathLib.sumOfSquaredDifferenceUnchecked(array1, array2) / (double)array1.length;
    }

    public static double sumOfSquaredDifferenceUnchecked(double[] array1, double[] array2) {
        double result = 0.0;
        int i = 0;
        while (i < array1.length) {
            result += (array1[i] - array2[i]) * (array1[i] - array2[i]);
            ++i;
        }
        return result;
    }

    public static double limitToRangeAndAssertNumerical(double value, double min, double max) {
        if (MathLib.isNaN(value)) {
            throw new IllegalArgumentException("The given value is not a number.");
        }
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static void checkNotNaNAndWithinRange(double value, double min, double max) {
        if (value < min || value > max || MathLib.isNaN(value)) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkWithinRange(int value, int min, int max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException();
        }
    }

    public static double dotProductUnchecked(double[] f1, double[] f2) {
        double sum = 0.0;
        int i = 0;
        while (i < f1.length) {
            try {
                sum += f1[i] * f2[i];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
        return sum;
    }

    public static double dotProductUnchecked(boolean[] f1, double[] f2, boolean complement) {
        double sum = 0.0;
        int i = 0;
        while (i < f1.length) {
            try {
                if (!complement == f1[i]) {
                    sum += f2[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
        return sum;
    }

    public static double dotProductUnchecked(boolean[] f1, double[] f2, double[] f3, boolean complement) {
        double sum = 0.0;
        int i = 0;
        while (i < f1.length) {
            try {
                if (!complement == f1[i]) {
                    sum += f2[i] * f3[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            ++i;
        }
        return sum;
    }

    public static Point2D.Double addPointsUnchecked(Point2D.Double p1, Point2D.Double p2) {
        return new Point2D.Double(p1.getX() + p2.getX(), p1.getY() + p2.getY());
    }

    public static Point2D.Double getRectCenterUnchecked(Rectangle2D.Double rect) {
        return new Point2D.Double(rect.getX() + rect.getWidth() / 2.0, rect.getY() + rect.getHeight() / 2.0);
    }

    public static Point2D.Double lineIntersectRectUnchecked(Rectangle2D.Double r, Point2D.Double s, Point2D.Double t) {
        Line2D.Double line = new Line2D.Double(s, t);
        if (line.intersectsLine(r.getX(), r.getY(), r.getX() + r.getWidth(), r.getY())) {
            return MathLib.intersectUnchecked(r.getX(), r.getY(), r.getX() + r.getWidth(), r.getY(), line);
        }
        if (line.intersectsLine(r.getX(), r.getY(), r.getX(), r.getY() + r.getHeight())) {
            return MathLib.intersectUnchecked(r.getX(), r.getY(), r.getX(), r.getY() + r.getHeight(), line);
        }
        if (line.intersectsLine(r.getX() + r.getWidth(), r.getY(), r.getX() + r.getWidth(), r.getY() + r.getHeight())) {
            return MathLib.intersectUnchecked(r.getX() + r.getWidth(), r.getY(), r.getX() + r.getWidth(), r.getY() + r.getHeight(), line);
        }
        if (line.intersectsLine(r.getX(), r.getY() + r.getHeight(), r.getX() + r.getWidth(), r.getY() + r.getHeight())) {
            return MathLib.intersectUnchecked(r.getX(), r.getY() + r.getHeight(), r.getX() + r.getWidth(), r.getY() + r.getHeight(), line);
        }
        return t;
    }

    public static Point2D.Double intersectUnchecked(double ax1, double ay1, double ax2, double ay2, double bx1, double by1, double bx2, double by2) {
        if (ax1 == ax2 && bx1 == bx2) {
            return null;
        }
        if (ax1 == ax2) {
            double mb = (by1 - by2) / (bx1 - bx2);
            double tb = by1 - mb * bx1;
            double x = ax1;
            double y = mb * x + tb;
            return new Point2D.Double(x, y);
        }
        if (bx1 == bx2) {
            double ma = (ay1 - ay2) / (ax1 - ax2);
            double ta = ay1 - ma * ax1;
            double x = bx1;
            double y = ma * x + ta;
            return new Point2D.Double(x, y);
        }
        double ma = (ay1 - ay2) / (ax1 - ax2);
        double mb = (by1 - by2) / (bx1 - bx2);
        if (ma == mb) {
            return null;
        }
        double ta = ay1 - ma * ax1;
        double tb = by1 - mb * bx1;
        double x = (tb - ta) / (ma - mb);
        double y = ma * x + ta;
        return new Point2D.Double(x, y);
    }

    public static Point2D.Double intersectUnchecked(double ax1, double ay1, double ax2, double ay2, Line2D.Double lineB) {
        return MathLib.intersectUnchecked(ax1, ay1, ax2, ay2, lineB.getX1(), lineB.getY1(), lineB.getX2(), lineB.getY2());
    }

    public static Point2D.Double intersectUnchecked(Line2D.Double lineA, Line2D.Double lineB) {
        return MathLib.intersectUnchecked(lineA.getX1(), lineA.getY1(), lineA.getX2(), lineA.getY2(), lineB);
    }

    public static double lengthUnchecked(double[] point) {
        double result = 0.0;
        int i = 0;
        while (i < point.length) {
            result += point[i] * point[i];
            ++i;
        }
        return Math.sqrt(result);
    }

    public static void scaleUnchecked(double[] vector, double scale) {
        int i = 0;
        while (i < vector.length) {
            int n = i++;
            vector[n] = vector[n] * scale;
        }
    }

    public static double[] differenceUnchecked(double[] minuend, double[] subtrahend) {
        double[] result = new double[minuend.length];
        int i = 0;
        while (i < minuend.length) {
            result[i] = minuend[i] - subtrahend[i];
            ++i;
        }
        return result;
    }

    public static void addToUnchecked(double[] addend1, double[] addend2) {
        int i = 0;
        while (i < addend1.length) {
            int n = i;
            addend1[n] = addend1[n] + addend2[i];
            ++i;
        }
    }

    public static double[] randomVector(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Can't create a random array of negative length.");
        }
        double[] result = new double[length];
        int i = 0;
        while (i < length) {
            result[i] = Math.random();
            ++i;
        }
        return result;
    }

    public static void addRandomVectors(ArrayList<double[]> list, int number, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Can't create a random array of negative length.");
        }
        if (number < 0) {
            throw new IllegalArgumentException("Can't add a negative number of vector.");
        }
        int i = 0;
        while (i < number) {
            list.add(MathLib.randomVector(length));
            ++i;
        }
    }

    public static double[] randomElement(ArrayList<double[]> ... lists) {
        int startList;
        int i = startList = MathLib.randomInt(lists.length - 1);
        while (i < lists.length + startList) {
            if (lists[i % lists.length].size() != 0) {
                return lists[i % lists.length].get(MathLib.randomInt(lists[i % lists.length].size() - 1));
            }
            ++i;
        }
        throw new IllegalArgumentException("No items found");
    }

    public static double[] meanVectorUnchecked(ArrayList<double[]> ... lists) {
        double[] result = null;
        double countedVectors = 0.0;
        ArrayList<double[]>[] arrayListArray = lists;
        int n = lists.length;
        int n2 = 0;
        while (n2 < n) {
            ArrayList<double[]> list = arrayListArray[n2];
            for (double[] vector : list) {
                if (result == null) {
                    result = new double[vector.length];
                }
                MathLib.addToUnchecked(result, vector);
                countedVectors += 1.0;
            }
            ++n2;
        }
        MathLib.scaleUnchecked(result, 1.0 / countedVectors);
        return result;
    }

    public static int randomInt(int max) {
        return (int)((double)(max + 1) * Math.random());
    }

    public static double far(double from) {
        double candidate;
        do {
            candidate = Math.random();
        } while (!(Math.random() < (candidate - from) * (candidate - from)));
        return candidate;
    }

    public static double near(double from) {
        double candidate;
        double prob;
        do {
            candidate = Math.random();
            prob = 1.0 - (candidate - from) * (candidate - from);
        } while (!(Math.random() < prob));
        return candidate;
    }

    public static double max(double[] values) {
        double result = -1.7976931348623157E308;
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            result = Math.max(result, value);
            ++n2;
        }
        return result;
    }

    public static double[] transformByteArrayToDoubleArrayUnchecked(byte[] bytes) {
        double[] result = new double[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            result[i] = bytes[i];
            ++i;
        }
        return result;
    }

    public static boolean isNaN(double value) {
        return Double.valueOf(value).isNaN();
    }

    public static boolean isNotNaN(double value) {
        return !MathLib.isNaN(value);
    }
}

