/*
 * Decompiled with CFR 0.152.
 */
package jimena.libs;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class TxtFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -7783911168522977256L;
    private static FileFilter txtFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().matches(".*\\.txt$") || file.isDirectory();
        }

        @Override
        public String getDescription() {
            return "txt-files (*.txt)";
        }
    };

    public TxtFileChooser() {
        FileFilter[] fileFilterArray = this.getChoosableFileFilters();
        int n = fileFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            FileFilter filter = fileFilterArray[n2];
            this.removeChoosableFileFilter(filter);
            ++n2;
        }
        this.addChoosableFileFilter(txtFilter);
        this.setDialogTitle("Save to a text-file");
        this.setDialogType(1);
    }

    public static FileFilter getTxtFilter() {
        return txtFilter;
    }

    public static void writeToTextFile(String string, Component parent) {
        TxtFileChooser filechooser = new TxtFileChooser();
        int returnVal = filechooser.showSaveDialog(parent);
        if (returnVal == 0) {
            try {
                File file = filechooser.getSelectedFile();
                if (!TxtFileChooser.getTxtFilter().accept(filechooser.getSelectedFile())) {
                    file = new File(String.valueOf(file.toString()) + ".txt");
                }
                BufferedWriter writer = new BufferedWriter(new FileWriter(file));
                writer.write(string);
                writer.close();
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), "Export failed", 0);
            }
        }
    }
}

