/*
 * Decompiled with CFR 0.152.
 */
package jimena.settings;

import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JTextField;
import jimena.libs.MathLib;
import jimena.settings.AbstractSetting;
import jimena.settings.RawSetting;

public class DoubleSetting
extends AbstractSetting<Double> {
    private RawSetting.SettingsTextField settingsTextField = new DoubleSettingsTextField();

    public DoubleSetting(String key, String label, String description, double minValue, double maxValue, double defaultValue) {
        super(key, label, description, minValue, maxValue, defaultValue);
        if (MathLib.isNaN(minValue) || MathLib.isNaN(maxValue)) {
            throw new IllegalArgumentException("No NaN values allowed.");
        }
        MathLib.checkNotNaNAndWithinRange(defaultValue, minValue, maxValue);
    }

    @Override
    public Double getValue() {
        return preferences.getDouble(this.getKey(), (Double)this.defaultValue);
    }

    @Override
    public JTextField getTextField() {
        return this.settingsTextField;
    }

    @Override
    public void reset() {
        this.settingsTextField.reset();
    }

    public class DoubleSettingsTextField
    extends RawSetting.SettingsTextField {
        private static final long serialVersionUID = -8521178246566337503L;

        public DoubleSettingsTextField() {
            super(DoubleSetting.this);
            this.setText(String.valueOf(DoubleSetting.this.getValue()));
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent arg0) {
                    try {
                        if (Double.valueOf(DoubleSettingsTextField.this.getText()) < (Double)((DoubleSettingsTextField)DoubleSettingsTextField.this).DoubleSetting.this.minValue) {
                            DoubleSettingsTextField.this.setText(String.valueOf(((DoubleSettingsTextField)DoubleSettingsTextField.this).DoubleSetting.this.minValue));
                        }
                        if (Double.valueOf(DoubleSettingsTextField.this.getText()) > (Double)((DoubleSettingsTextField)DoubleSettingsTextField.this).DoubleSetting.this.maxValue) {
                            DoubleSettingsTextField.this.setText(String.valueOf(((DoubleSettingsTextField)DoubleSettingsTextField.this).DoubleSetting.this.maxValue));
                        }
                    }
                    catch (NumberFormatException e) {
                        DoubleSettingsTextField.this.setText(String.valueOf(((DoubleSettingsTextField)DoubleSettingsTextField.this).DoubleSetting.this.defaultValue));
                    }
                    preferences.putDouble(DoubleSetting.this.getKey(), Double.valueOf(DoubleSettingsTextField.this.getText()));
                }
            });
        }

        @Override
        public void reset() {
            this.setText(String.valueOf(DoubleSetting.this.defaultValue));
            preferences.putDouble(DoubleSetting.this.getKey(), Double.valueOf(this.getText()));
        }
    }
}

