/*
 * Decompiled with CFR 0.152.
 */
package jimena.ssssearcher;

import java.util.ArrayList;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.libs.MathLib;
import jimena.simulation.CalculationController;
import jimena.simulationmethods.SimulationMethod;
import jimena.ssssearcher.SSSSearcher;

public abstract class StepwiseSearcher
extends SSSSearcher {
    protected abstract ArrayList<double[]> getNextSteps(RegulatoryNetwork var1, ArrayList<double[]> var2, ArrayList<double[]> var3);

    @Override
    public ArrayList<double[]> searchSSStates(RegulatoryNetwork network, long maxTime, SimulationMethod method, double dt, double maxt, double stabilityMaxDiff, double stabilityMinTime, double duplicateMaxDiff, CalculationController calculationController, int threads) {
        long start = System.currentTimeMillis();
        int stepsDone = 0;
        ArrayList<double[]> oldStarts = new ArrayList<double[]>();
        ArrayList<double[]> foundStableStates = new ArrayList<double[]>();
        ArrayList<byte[]> discreteStableSteadyStates = network.discreteStableSteadyStates();
        for (byte[] bytes : discreteStableSteadyStates) {
            oldStarts.add(MathLib.transformByteArrayToDoubleArrayUnchecked(bytes));
        }
        int startVectorCount = 10;
        MathLib.addRandomVectors(oldStarts, 10, network.nodeCount());
        stepsDone += oldStarts.size();
        ArrayList<double[]> initialResults = StepwiseSearcher.executeSearch(oldStarts, network, method, dt, maxt, stabilityMaxDiff, stabilityMinTime, true, threads, maxTime + start - System.currentTimeMillis());
        this.addWithoutDuplicates(foundStableStates, initialResults, duplicateMaxDiff);
        while (System.currentTimeMillis() - start < maxTime) {
            ArrayList<double[]> newStarts = this.getNextSteps(network, oldStarts, foundStableStates);
            this.addWithoutDuplicates(foundStableStates, StepwiseSearcher.executeSearch(newStarts, network, method, dt, maxt, stabilityMaxDiff, stabilityMinTime, false, threads, maxTime + start - System.currentTimeMillis()), duplicateMaxDiff);
            oldStarts.addAll(newStarts);
            stepsDone += newStarts.size();
            if (calculationController == null) continue;
            if (!calculationController.isOn()) {
                return null;
            }
            calculationController.setProgress((double)(System.currentTimeMillis() - start) / (double)maxTime, stepsDone);
        }
        if (calculationController != null) {
            calculationController.notifyCalculationFinished();
        }
        return foundStableStates;
    }
}

