/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.math.BigInteger;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDBitVector;
import net.sf.javabdd.BDDException;
import net.sf.javabdd.BDDFactory;

public abstract class BDDDomain {
    protected String name;
    protected int index;
    protected BigInteger realsize;
    protected int[] ivar;
    protected BDD var;

    protected BDDDomain(int index, BigInteger range) {
        BigInteger calcsize = BigInteger.valueOf(2L);
        if (range.signum() <= 0) {
            throw new BDDException();
        }
        this.name = Integer.toString(index);
        this.index = index;
        this.realsize = range;
        int binsize = 1;
        while (calcsize.compareTo(range) < 0) {
            ++binsize;
            calcsize = calcsize.shiftLeft(1);
        }
        this.ivar = new int[binsize];
    }

    public abstract BDDFactory getFactory();

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getIndex() {
        return this.index;
    }

    public BDD domain() {
        BDDFactory factory = this.getFactory();
        BigInteger val = this.size().subtract(BigInteger.ONE);
        BDD d = factory.one();
        int[] ivar = this.vars();
        int n = 0;
        while (n < this.varNum()) {
            if (val.testBit(0)) {
                d.orWith(factory.nithVar(ivar[n]));
            } else {
                d.andWith(factory.nithVar(ivar[n]));
            }
            val = val.shiftRight(1);
            ++n;
        }
        return d;
    }

    public BigInteger size() {
        return this.realsize;
    }

    public BDD buildAdd(BDDDomain that, long value) {
        if (this.varNum() != that.varNum()) {
            throw new BDDException();
        }
        return this.buildAdd(that, this.varNum(), value);
    }

    public BDD buildAdd(BDDDomain that, int bits, long value) {
        BDD b;
        if (bits > this.varNum() || bits > that.varNum()) {
            throw new BDDException("Number of bits requested (" + bits + ") is larger than domain sizes " + this.varNum() + "," + that.varNum());
        }
        BDDFactory bdd2 = this.getFactory();
        if (value == 0L) {
            BDD b2;
            BDD result = bdd2.one();
            int n = 0;
            while (n < bits) {
                b2 = bdd2.ithVar(this.ivar[n]);
                b2.biimpWith(bdd2.ithVar(that.ivar[n]));
                result.andWith(b2);
                ++n;
            }
            while (n < Math.max(this.varNum(), that.varNum())) {
                b2 = n < this.varNum() ? bdd2.nithVar(this.ivar[n]) : bdd2.one();
                b2.andWith(n < that.varNum() ? bdd2.nithVar(that.ivar[n]) : bdd2.one());
                result.andWith(b2);
                ++n;
            }
            return result;
        }
        int[] vars = new int[bits];
        System.arraycopy(this.ivar, 0, vars, 0, vars.length);
        BDDBitVector y = bdd2.buildVector(vars);
        BDDBitVector v = bdd2.constantVector(bits, value);
        BDDBitVector z = y.add(v);
        int[] thatvars = new int[bits];
        System.arraycopy(that.ivar, 0, thatvars, 0, thatvars.length);
        BDDBitVector x = bdd2.buildVector(thatvars);
        BDD result = bdd2.one();
        int n = 0;
        while (n < x.size()) {
            b = x.bitvec[n].biimp(z.bitvec[n]);
            result.andWith(b);
            ++n;
        }
        while (n < Math.max(this.varNum(), that.varNum())) {
            b = n < this.varNum() ? bdd2.nithVar(this.ivar[n]) : bdd2.one();
            b.andWith(n < that.varNum() ? bdd2.nithVar(that.ivar[n]) : bdd2.one());
            result.andWith(b);
            ++n;
        }
        x.free();
        y.free();
        z.free();
        v.free();
        return result;
    }

    public BDD buildEquals(BDDDomain that) {
        if (!this.size().equals(that.size())) {
            throw new BDDException("Size of " + this + " != size of that " + that + "( " + this.size() + " vs " + that.size() + ")");
        }
        BDDFactory factory = this.getFactory();
        BDD e = factory.one();
        int[] this_ivar = this.vars();
        int[] that_ivar = that.vars();
        int n = 0;
        while (n < this.varNum()) {
            BDD a = factory.ithVar(this_ivar[n]);
            BDD b = factory.ithVar(that_ivar[n]);
            a.biimpWith(b);
            e.andWith(a);
            ++n;
        }
        return e;
    }

    public BDD set() {
        return this.var.id();
    }

    public BDD ithVar(long val) {
        return this.ithVar(BigInteger.valueOf(val));
    }

    public BDD ithVar(BigInteger val) {
        if (val.signum() < 0 || val.compareTo(this.size()) >= 0) {
            throw new BDDException(val + " is out of range");
        }
        BDDFactory factory = this.getFactory();
        BDD v = factory.one();
        int[] ivar = this.vars();
        int n = 0;
        while (n < ivar.length) {
            if (val.testBit(0)) {
                v.andWith(factory.ithVar(ivar[n]));
            } else {
                v.andWith(factory.nithVar(ivar[n]));
            }
            val = val.shiftRight(1);
            ++n;
        }
        return v;
    }

    public BDD varRange(long lo, long hi) {
        return this.varRange(BigInteger.valueOf(lo), BigInteger.valueOf(hi));
    }

    public BDD varRange(BigInteger lo, BigInteger hi) {
        if (lo.signum() < 0 || hi.compareTo(this.size()) >= 0 || lo.compareTo(hi) > 0) {
            throw new BDDException("range <" + lo + ", " + hi + "> is invalid");
        }
        BDDFactory factory = this.getFactory();
        BDD result = factory.zero();
        int[] ivar = this.vars();
        while (lo.compareTo(hi) <= 0) {
            BigInteger mask;
            BDD v = factory.one();
            int n = ivar.length - 1;
            while (true) {
                if (lo.testBit(n)) {
                    v.andWith(factory.ithVar(ivar[n]));
                } else {
                    v.andWith(factory.nithVar(ivar[n]));
                }
                mask = BigInteger.ONE.shiftLeft(n).subtract(BigInteger.ONE);
                if (!lo.testBit(n) && lo.or(mask).compareTo(hi) <= 0) break;
                --n;
            }
            lo = lo.or(mask).add(BigInteger.ONE);
            result.orWith(v);
        }
        return result;
    }

    public int varNum() {
        return this.ivar.length;
    }

    public int[] vars() {
        return this.ivar;
    }

    public int ensureCapacity(long range) {
        return this.ensureCapacity(BigInteger.valueOf(range));
    }

    public int ensureCapacity(BigInteger range) {
        BigInteger calcsize = BigInteger.valueOf(2L);
        if (range.signum() < 0) {
            throw new BDDException();
        }
        if (range.compareTo(this.realsize) < 0) {
            return this.ivar.length;
        }
        this.realsize = range.add(BigInteger.ONE);
        int binsize = 1;
        while (calcsize.compareTo(range) <= 0) {
            ++binsize;
            calcsize = calcsize.shiftLeft(1);
        }
        if (this.ivar.length == binsize) {
            return binsize;
        }
        int[] new_ivar = new int[binsize];
        System.arraycopy(this.ivar, 0, new_ivar, 0, this.ivar.length);
        BDDFactory factory = this.getFactory();
        int i = this.ivar.length;
        while (i < new_ivar.length) {
            int newVar = factory.duplicateVar(new_ivar[i - 1]);
            ++factory.firstbddvar;
            new_ivar[i] = newVar;
            ++i;
        }
        this.ivar = new_ivar;
        this.var.free();
        BDD nvar = factory.one();
        int i2 = 0;
        while (i2 < this.ivar.length) {
            nvar.andWith(factory.ithVar(this.ivar[i2]));
            ++i2;
        }
        this.var = nvar;
        return binsize;
    }

    public String toString() {
        return this.getName();
    }

    public BigInteger[] getVarIndices(BDD bdd2) {
        return this.getVarIndices(bdd2, -1);
    }

    public BigInteger[] getVarIndices(BDD bdd2, int max) {
        BDD myvarset = this.set();
        int n = (int)bdd2.satCount(myvarset);
        if (max != -1 && n > max) {
            n = max;
        }
        BigInteger[] res = new BigInteger[n];
        BDD.BDDIterator it = bdd2.iterator(myvarset);
        int i = 0;
        while (i < n) {
            BDD bi = (BDD)it.next();
            res[i] = bi.scanVar(this);
            ++i;
        }
        myvarset.free();
        return res;
    }
}

