/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulationmethods;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.simulationmethods.ContinuousSimulationMethod;

public class HillCubeInterpolationMethod
extends ContinuousSimulationMethod {
    @Override
    public double getDerivativeValue(RegulatoryNetwork network, int nodeIndex, double[] values) {
        NetworkNode node = network.getNetworkNodes()[nodeIndex];
        BinaryBooleanFunction function = node.getFunction();
        double interpol = function.interpolateBoolOrHillCube(this.getInputs(network, nodeIndex, values), true, false, node.getHillNs(), node.getHillKs());
        return (interpol - values[nodeIndex]) / network.getNetworkNodes()[nodeIndex].getOdeDecay();
    }

    @Override
    public String toString() {
        return "HillCube";
    }
}

