/*
 * Decompiled with CFR 0.152.
 */
package jimena.ssssearcher;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.simulation.CalculationController;
import jimena.simulation.SSSFromStartVector;
import jimena.simulationmethods.SimulationMethod;

public abstract class SSSSearcher {
    public abstract ArrayList<double[]> searchSSStates(RegulatoryNetwork var1, long var2, SimulationMethod var4, double var5, double var7, double var9, double var11, double var13, CalculationController var15, int var16);

    protected static ArrayList<double[]> executeSearch(ArrayList<double[]> startVectors, RegulatoryNetwork network, SimulationMethod method, double dt, double maxt, double stabilityMaxDiff, double stabilityMinTime, boolean simulatedAnnealing, int threads, long maxTime) {
        int i;
        SSSFromStartVector[] searchers;
        ExecutorService threadPool;
        ArrayList<double[]> results = new ArrayList<double[]>();
        long start = System.currentTimeMillis();
        ArrayList<double[]> realStartVectors = new ArrayList<double[]>();
        if (!simulatedAnnealing) {
            threadPool = Executors.newFixedThreadPool(threads);
            searchers = new SSSFromStartVector[startVectors.size()];
            i = 0;
            while (i < startVectors.size()) {
                searchers[i] = network.annealingStableSteadyStateSearcher(startVectors.get(i), method, (long)maxt);
                threadPool.submit(searchers[i]);
                ++i;
            }
            threadPool.shutdown();
            try {
                while (System.currentTimeMillis() - start <= maxTime && !threadPool.isTerminated()) {
                    threadPool.awaitTermination(250L, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException e1) {
                return new ArrayList<double[]>();
            }
            i = 0;
            while (i < startVectors.size()) {
                if (searchers[i].getResult() != null) {
                    realStartVectors.add(searchers[i].getResult());
                }
                ++i;
            }
        } else {
            for (double[] vector : startVectors) {
                realStartVectors.add(vector);
            }
        }
        threadPool = Executors.newFixedThreadPool(threads);
        searchers = new SSSFromStartVector[realStartVectors.size()];
        i = 0;
        while (i < realStartVectors.size()) {
            searchers[i] = network.stableSteadyStateSearcher((double[])realStartVectors.get(i), stabilityMaxDiff, stabilityMinTime, method, dt, maxt, null);
            threadPool.submit(searchers[i]);
            ++i;
        }
        threadPool.shutdown();
        try {
            while (System.currentTimeMillis() - start <= maxTime && !threadPool.isTerminated()) {
                threadPool.awaitTermination(250L, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e1) {
            throw new RuntimeException("Interrupted.");
        }
        i = 0;
        while (i < searchers.length) {
            if (searchers[i].getResult() != null) {
                results.add(searchers[i].getResult());
            }
            ++i;
        }
        return results;
    }

    protected void addWithoutDuplicates(ArrayList<double[]> store, ArrayList<double[]> newItems, double duplicateMaxDiff) {
        for (double[] newItem : newItems) {
            this.addDuplicateFree(store, newItem, duplicateMaxDiff);
        }
    }

    protected void addDuplicateFree(ArrayList<double[]> store, double[] newItem, double duplicateMaxDiff) {
        for (double[] oldItem : store) {
            boolean isIdentical = true;
            int i = 0;
            while (i < newItem.length) {
                if (Math.abs(newItem[i] - oldItem[i]) > duplicateMaxDiff) {
                    isIdentical = false;
                    break;
                }
                ++i;
            }
            if (!isIdentical) continue;
            return;
        }
        store.add(newItem);
    }
}

