/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf.treebf;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jimena.binarybf.BinaryBooleanFunction;
import jimena.binarybf.treebf.ANDBinaryNode;
import jimena.binarybf.treebf.ConstantNode;
import jimena.binarybf.treebf.InputNode;
import jimena.binarybf.treebf.NotNode;
import jimena.binarybf.treebf.ORBinaryNode;
import jimena.binarybf.treebf.TreeNode;
import jimena.binarybf.treebf.TreeNodeLib;
import jimena.libs.PatternLib;
import jimena.libs.SearchResult;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class TreeBooleanFunction
extends BinaryBooleanFunction {
    private static final long serialVersionUID = 7224250583219201061L;
    private TreeNode root;
    private int arity;

    @Override
    public int getArity() {
        return this.arity;
    }

    public TreeBooleanFunction(String expression, int arity) {
        this.root = this.parse(expression);
        if (this.root.getMinArity() > arity) {
            throw new IllegalArgumentException("Arity of the function must be greater than the index of the highest input.");
        }
        this.arity = arity;
    }

    public TreeBooleanFunction(String expression) {
        this.root = this.parse(expression);
        this.arity = this.root.getMinArity();
    }

    public TreeBooleanFunction(TreeNode root) {
        this(root, root.getMinArity());
    }

    public TreeBooleanFunction(TreeNode root, int arity) {
        if (root == null) {
            throw new NullPointerException();
        }
        if (root.isCyclic()) {
            throw new IllegalArgumentException("The tree of a boolean function must be a acyclic.");
        }
        this.root = root;
        this.arity = arity;
    }

    public TreeBooleanFunction(boolean[] activators) {
        if (activators == null) {
            throw new NullPointerException("Provide an empty array instead of null to create the nullary constant-false function");
        }
        ArrayList<TreeNode> activatorNodes = new ArrayList<TreeNode>();
        ArrayList<TreeNode> inactivatorNodes = new ArrayList<TreeNode>();
        int i = 0;
        while (i < activators.length) {
            if (activators[i]) {
                activatorNodes.add(new InputNode(i));
            } else {
                inactivatorNodes.add(new InputNode(i));
            }
            ++i;
        }
        this.root = TreeNodeLib.getActInactTree(activatorNodes, inactivatorNodes);
        this.arity = activators.length;
    }

    private TreeNode parse(String expression) {
        if ((expression = expression.trim()).startsWith("(") && expression.endsWith(")")) {
            return this.parse(expression.substring(1, expression.length() - 1));
        }
        SearchResult match = TreeBooleanFunction.nonBracketedIndexOf(expression, PatternLib.CONTAINSORPATTERN);
        if (match != null) {
            return new ORBinaryNode(this.parse(expression.substring(0, match.getStart() - 1)), this.parse(expression.substring(match.getEnd(), expression.length())));
        }
        match = TreeBooleanFunction.nonBracketedIndexOf(expression, PatternLib.CONTAINSANDPATTERN);
        if (match != null) {
            return new ANDBinaryNode(this.parse(expression.substring(0, match.getStart() - 1)), this.parse(expression.substring(match.getEnd(), expression.length())));
        }
        match = TreeBooleanFunction.nonBracketedIndexOf(expression, PatternLib.STARTSWITHNOTPATTERN);
        if (match != null && match.getStart() == 0) {
            return new NotNode(this.parse(expression.substring(match.getEnd(), expression.length())));
        }
        if (PatternLib.ENTIRENUMBERPATTERN.matcher(expression).matches()) {
            return new InputNode(Integer.valueOf(expression));
        }
        if (expression.equalsIgnoreCase("true")) {
            return new ConstantNode(true);
        }
        if (expression.equalsIgnoreCase("false")) {
            return new ConstantNode(false);
        }
        throw new IllegalArgumentException("Input isn't a valid boolean function definition. Please consult the javadoc for a detailed description.");
    }

    private static SearchResult nonBracketedIndexOf(String haystack, Pattern needle) {
        Matcher m = needle.matcher(haystack);
        while (m.find()) {
            if (TreeBooleanFunction.countBrackets(haystack, true, 0, m.start()) != TreeBooleanFunction.countBrackets(haystack, false, 0, m.start())) continue;
            return new SearchResult(m.start(), m.end());
        }
        return null;
    }

    private static int countBrackets(String haystack, boolean opening, int start, int end) {
        int counter2 = 0;
        int i = start;
        while (i <= end) {
            if (opening) {
                if (haystack.charAt(i) == '(') {
                    ++counter2;
                }
            } else if (haystack.charAt(i) == ')') {
                ++counter2;
            }
            ++i;
        }
        return counter2;
    }

    @Override
    public boolean eval(boolean[] inputs) {
        return this.root.eval(inputs);
    }

    @Override
    public double interpolateSQUAD(double[] input, double[] squadWeights) throws BinaryBooleanFunction.InterpolationMethodNotSupported {
        throw new BinaryBooleanFunction.InterpolationMethodNotSupported();
    }

    @Override
    public double interpolateBoolCube(double[] input) {
        return this.root.interpolateBooleCube(input);
    }

    @Override
    public TreeBooleanFunction clone() {
        return new TreeBooleanFunction(this.root.clone());
    }

    @Override
    protected BDD createBDDUnchecked(BDD[] inputs, BDDFactory bddFactory) {
        return this.root.createBDD(inputs, bddFactory);
    }
}

