/*
 * Decompiled with CFR 0.152.
 */
package jimena.perturbation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.perturbation.OnOffPerturbation;
import jimena.perturbation.Perturbation;
import jimena.perturbation.PerturbationsModel;
import jimena.perturbation.RandomPerturbation;
import jimena.perturbation.SinePerturbation;

public class PerturbationsWindow
extends JFrame {
    private static final long serialVersionUID = 2436247424568506717L;
    private RegulatoryNetwork network;
    private JTable table;
    private PerturbationsModel model;

    public PerturbationsWindow(RegulatoryNetwork network) {
        super("Perturbations");
        this.setIconImage(new ImageIcon("images" + File.separator + "settings16.png").getImage());
        this.network = network;
        this.setMinimumSize(new Dimension(300, 10));
        this.getContentPane().setLayout(new BorderLayout());
        this.model = new PerturbationsModel(network);
        this.table = new JTable(this.model){
            private static final long serialVersionUID = 2476811052242836099L;

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                PerturbationsWindow.this.pack();
            }
        };
        this.table.setToolTipText("Double-click to show perturbation details.");
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1 && e.getClickCount() == 2) {
                    PerturbationsWindow.this.model.rowToPerturbation(PerturbationsWindow.this.table.rowAtPoint(e.getPoint())).setVisible(true);
                    PerturbationsWindow.this.network.notifyObserversOfChangedValues();
                }
            }
        });
        this.table.setTableHeader(null);
        this.getContentPane().add((Component)new JScrollPane(this.table), "Center");
        JPanel controlPanel = new JPanel(new GridLayout(1, 2));
        JButton addPerturbation = new JButton("Add New Perturbation");
        this.getRootPane().setDefaultButton(addPerturbation);
        addPerturbation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PerturbationsWindow.this.network.isEmpty()) {
                    return;
                }
                NetworkNode node = (NetworkNode)JOptionPane.showInputDialog(PerturbationsWindow.this, "Node of the new perturbation: ", "Choose the node", -1, new ImageIcon(), PerturbationsWindow.this.network.getNetworkNodes(), PerturbationsWindow.this.network.getNetworkNodes()[0]);
                if (node == null) {
                    return;
                }
                Object[] perturbations = new Perturbation[]{new OnOffPerturbation(), new RandomPerturbation(), new SinePerturbation()};
                Perturbation perturbation = (Perturbation)JOptionPane.showInputDialog(PerturbationsWindow.this, "Type of the new perturbation: ", "Choose the type", -1, new ImageIcon(), perturbations, perturbations[0]);
                if (perturbation == null) {
                    return;
                }
                perturbation.setVisible(true);
                if (!perturbation.creationWasAborted()) {
                    node.getPerturbations().add(perturbation);
                    PerturbationsWindow.this.network.notifyObserversOfChangedValues();
                }
            }
        });
        controlPanel.add(addPerturbation);
        JButton removePerturbation = new JButton("Remove Perturbation");
        removePerturbation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PerturbationsWindow.this.table.getSelectedColumn() != -1) {
                    PerturbationsWindow.this.model.deletePerturbation(PerturbationsWindow.this.table.getSelectedColumn());
                }
                PerturbationsWindow.this.network.notifyObserversOfChangedValues();
            }
        });
        controlPanel.add(removePerturbation);
        this.getContentPane().add((Component)controlPanel, "Last");
        this.pack();
        this.setResizable(false);
        this.setDefaultCloseOperation(1);
    }
}

