/*
 * Decompiled with CFR 0.152.
 */
package jimena.perturbation;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jimena.libs.DoubleValue;
import jimena.libs.StandardNumberFormat;
import jimena.perturbation.Perturbation;

public abstract class RealValuesPerturbation
extends Perturbation {
    private static final long serialVersionUID = 7586496493366760927L;
    private DoubleValue[] values;
    private JFormattedTextField[] valueFields;
    private boolean creationAborted = false;

    public RealValuesPerturbation(DoubleValue[] values, String[] valueNames) {
        if (values.length != valueNames.length) {
            throw new IllegalArgumentException("Number of values must correspond to the number of value Descriptions.");
        }
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            DoubleValue value = objectArray[n2];
            if (value == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
        objectArray = valueNames;
        n = valueNames.length;
        n2 = 0;
        while (n2 < n) {
            Object valueName = objectArray[n2];
            if (valueName == null) {
                throw new NullPointerException();
            }
            ++n2;
        }
        this.values = values;
        this.valueFields = new JFormattedTextField[values.length];
        int i = 0;
        while (i < values.length) {
            this.valueFields[i] = new JFormattedTextField(StandardNumberFormat.NUMBERFORMAT);
            ++i;
        }
        JPanel panel = new JPanel(new GridLayout(values.length + 1, 2, 12, 12));
        int i2 = 0;
        while (i2 < values.length) {
            panel.add(new JLabel(valueNames[i2]));
            panel.add(this.valueFields[i2]);
            ++i2;
        }
        JButton saveButton = new JButton("Save");
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < RealValuesPerturbation.this.values.length) {
                    try {
                        RealValuesPerturbation.this.values[i].setValue(Double.valueOf(RealValuesPerturbation.this.valueFields[i].getText()));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    ++i;
                }
                RealValuesPerturbation.this.setVisible(false);
            }
        });
        panel.add(saveButton);
        this.getRootPane().setDefaultButton(saveButton);
        JButton abortButton = new JButton("Abort");
        abortButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RealValuesPerturbation.this.creationAborted = true;
                RealValuesPerturbation.this.setVisible(false);
            }
        });
        panel.add(abortButton);
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setContentPane(panel);
        this.setMinimumSize(new Dimension(300, (values.length + 1) * 42));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                int i = 0;
                while (i < RealValuesPerturbation.this.values.length) {
                    RealValuesPerturbation.this.valueFields[i].setText(StandardNumberFormat.NUMBERFORMAT.format(RealValuesPerturbation.this.values[i].getValue()));
                    ++i;
                }
            }
        });
    }

    @Override
    public boolean creationWasAborted() {
        return this.creationAborted;
    }
}

