/*
 * Decompiled with CFR 0.152.
 */
import java.awt.geom.Point2D;
import java.io.File;
import java.util.Arrays;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.libs.StringLib;
import jimena.perturbation.OnOffPerturbation;
import jimena.simulation.ProgressWindow;
import jimena.simulationmethods.NormalizedHillCubeInterpolationMethod;
import jimena.ssssearcher.RandomSearcher;

public class Example {
    public static void main(String[] args) {
        RegulatoryNetwork network = new RegulatoryNetwork();
        try {
            network.loadYEdFile(new File("H:\\formalnetworks\\disable network 5.graphml"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(Arrays.toString(network.getNodeNames()));
        System.out.print("\n");
        network.getNetworkNodes()[2].setSQUADDecay(2.0);
        network.getNetworkNodes()[0].setValue(1.0);
        network.simulate(new NormalizedHillCubeInterpolationMethod(), 0.001, 10.0, Double.POSITIVE_INFINITY, 1.0, Double.POSITIVE_INFINITY, null);
        System.out.println(network.getTimeIndex() + "\n");
        for (Point2D.Double logEntry : network.getNetworkNodes()[0].getLog()) {
            System.out.println(String.valueOf(logEntry.getX()) + ": " + logEntry.getY());
        }
        System.out.print("\n");
        network.reset();
        network.getNetworkNodes()[0].getPerturbations().add(new OnOffPerturbation(0.0, 500000.0, 1.0));
        network.simulate(new NormalizedHillCubeInterpolationMethod(), 1.0E-4, 10.0, Double.POSITIVE_INFINITY, 1.0, 0.5, new ProgressWindow());
        for (Point2D.Double logEntry : network.getNetworkNodes()[0].getLog()) {
            System.out.println(String.valueOf(logEntry.getX()) + ": " + logEntry.getY());
        }
        System.out.print("\n");
        network.removeAllPerturbations();
        System.out.println(Arrays.toString(network.stableSteadyState(network.getValues(), 0.001, 5.0, new NormalizedHillCubeInterpolationMethod(), 0.001, 1000.0, null)));
        System.out.print("\n");
        StringLib.printDoubleVectorList(network.stableSteadyStates(0.001, 5.0, new NormalizedHillCubeInterpolationMethod(), 0.01, 50.0, 0.001, 5000L, new ProgressWindow(), 2, new RandomSearcher()));
        System.out.print("\n");
        StringLib.printByteVectorList(network.discreteStableSteadyStates());
        System.exit(0);
    }
}

