/*
 * Decompiled with CFR 0.152.
 */
package jimena.binaryrn;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetworkLib;
import jimena.binaryrn.RegulatoryNetworkObserver;
import jimena.libs.DoubleValue;
import jimena.libs.MathLib;
import jimena.libs.StandardNumberFormat;
import jimena.simulation.CalculationController;
import jimena.simulation.SSSFromStartVector;
import jimena.simulation.SimulatedAnnealingSSS;
import jimena.simulation.Simulator;
import jimena.simulation.StableSteadyState;
import jimena.simulationmethods.SimulationMethod;
import jimena.ssssearcher.SSSSearcher;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;
import net.sf.javabdd.JFactory;

public class RegulatoryNetwork
implements Serializable {
    private static final long serialVersionUID = -3637940236128103506L;
    private NetworkNode[] networkNodes = new NetworkNode[0];
    private transient HashSet<RegulatoryNetworkObserver> observers = new HashSet();
    private DoubleValue timeIndex = new DoubleValue(0.0);
    private final int THREADS = Runtime.getRuntime().availableProcessors();
    private static final int BDDPRESETS = 1000000;

    public String[] getNodeNames() {
        String[] names = new String[this.nodeCount()];
        int i = 0;
        while (i < this.nodeCount()) {
            names[i] = this.networkNodes[i].getName();
            ++i;
        }
        return names;
    }

    public ArrayList<byte[]> discreteStableSteadyStates() {
        BDDFactory bddFactory = JFactory.init(1000000, 1000000);
        bddFactory.setVarNum(this.nodeCount());
        BDD[] nodes = new BDD[this.nodeCount()];
        int i = 0;
        while (i < this.nodeCount()) {
            nodes[i] = bddFactory.ithVar(i);
            ++i;
        }
        BDD network = bddFactory.one();
        int i2 = 0;
        while (i2 < this.nodeCount()) {
            BDD[] inputs = new BDD[this.networkNodes[i2].getInputs().length];
            int j = 0;
            while (j < this.networkNodes[i2].getInputs().length) {
                inputs[j] = nodes[this.networkNodes[i2].getInputs()[j].getSource()];
                ++j;
            }
            BDD functionBDD = this.networkNodes[i2].getFunction().createBDD(inputs, bddFactory);
            network.andWith(nodes[i2].biimp(functionBDD));
            ++i2;
        }
        return MathLib.bddAllsatResultToArray(network.allsat());
    }

    private static void checkParameters(double stabilityMaxDiff, double stabilityMinTime, int simulationsPerInput, SimulationMethod method, double dt, double maxt) {
        if (stabilityMaxDiff < 0.0 || stabilityMinTime <= 0.0 || simulationsPerInput <= 0 || dt <= 0.0 || maxt <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (method == null) {
            throw new NullPointerException();
        }
    }

    public void simulate(SimulationMethod method, double dt, double maxt, double maxSpeed, double minSimulationTimeBetweenLogs, double minTimeBetweenNotifications, CalculationController calculationController) {
        Simulator simulator = new Simulator(this, method, dt, maxt, maxSpeed, minSimulationTimeBetweenLogs, minTimeBetweenNotifications, calculationController);
        simulator.start();
        try {
            simulator.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public ArrayList<double[]> stableSteadyStates(double stabilityMaxDiff, double stabilityMinTime, SimulationMethod method, double dt, double maxt, double duplicateMaxDiff, long maxTime, CalculationController calculationController, int threads, SSSSearcher sssSearcher) {
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, 1, method, dt, maxt);
        if (duplicateMaxDiff < 0.0 || maxTime <= 0L) {
            throw new IllegalArgumentException();
        }
        return sssSearcher.searchSSStates(this, maxTime, method, dt, maxt, stabilityMaxDiff, stabilityMinTime, duplicateMaxDiff, calculationController, threads);
    }

    public double[] stableSteadyState(double[] startValues, double stabilityMaxDiff, double stabilityMinTime, SimulationMethod method, double dt, double maxt, CalculationController calculationController) {
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, 1, method, dt, maxt);
        double[] dArray = startValues;
        int n = startValues.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            MathLib.checkNotNaNAndWithinRange(value, 0.0, 1.0);
            ++n2;
        }
        StableSteadyState stableSteadyState = this.stableSteadyStateSearcher(startValues, stabilityMaxDiff, stabilityMinTime, method, dt, maxt, calculationController);
        stableSteadyState.start();
        try {
            stableSteadyState.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return stableSteadyState.getResult();
    }

    public StableSteadyState stableSteadyStateSearcher(double[] startValues, double stabilityMaxDiff, double stabilityMinTime, SimulationMethod method, double dt, double maxt, CalculationController calculationController) {
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, 1, method, dt, maxt);
        double[] dArray = startValues;
        int n = startValues.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            MathLib.checkNotNaNAndWithinRange(value, 0.0, 1.0);
            ++n2;
        }
        RegulatoryNetwork searchingNetwork = this.cloneWithoutObserversAndLogAndANewTimeIndex();
        searchingNetwork.setValues(startValues);
        StableSteadyState stableSteadyState = new StableSteadyState(searchingNetwork, method, dt, maxt, stabilityMaxDiff, stabilityMinTime, calculationController);
        return stableSteadyState;
    }

    public SSSFromStartVector annealingStableSteadyStateSearcher(double[] startValues, SimulationMethod method, long maxt) {
        double[] dArray = startValues;
        int n = startValues.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            MathLib.checkNotNaNAndWithinRange(value, 0.0, 1.0);
            ++n2;
        }
        if (method == null) {
            throw new NullPointerException();
        }
        if (maxt <= 0L) {
            throw new IllegalArgumentException();
        }
        RegulatoryNetwork searchingNetwork = this.cloneWithoutObserversAndLogAndANewTimeIndex();
        searchingNetwork.setValues(startValues);
        SimulatedAnnealingSSS stableSteadyState = new SimulatedAnnealingSSS(searchingNetwork, method, maxt);
        return stableSteadyState;
    }

    public double[] getValues() {
        double[] result = new double[this.nodeCount()];
        int i = 0;
        while (i < this.nodeCount()) {
            result[i] = this.networkNodes[i].getValue();
            ++i;
        }
        return result;
    }

    public void setValues(double[] values) {
        int i = 0;
        while (i < values.length) {
            this.networkNodes[i].setValue(values[i]);
            ++i;
        }
    }

    public RegulatoryNetwork(NetworkNode[] networkNodes, DoubleValue timeIndex) {
        if (networkNodes == null || timeIndex == null) {
            throw new NullPointerException();
        }
        this.networkNodes = networkNodes;
        this.observers = new HashSet();
        this.timeIndex = timeIndex;
    }

    public void loadNetwork(RegulatoryNetwork storedNetwork) {
        this.networkNodes = storedNetwork.getNetworkNodes();
        this.timeIndex = storedNetwork.getTimeIndex();
        this.notifyObserversOfChangedNetwork();
    }

    public RegulatoryNetwork() {
    }

    public NetworkNode[] getNetworkNodes() {
        return this.networkNodes;
    }

    public void addObserver(RegulatoryNetworkObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers.add(observer);
    }

    public void removeObserver(RegulatoryNetworkObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers.remove(observer);
    }

    public void notifyObserversOfChangedNetwork() {
        for (RegulatoryNetworkObserver observer : this.observers) {
            observer.notifyNetworkChanged();
        }
    }

    public void notifyObserversOfChangedValues() {
        for (RegulatoryNetworkObserver observer : this.observers) {
            observer.notifyValuesChanged();
        }
    }

    public void loadYEdFile(File file) throws Exception {
        this.timeIndex = new DoubleValue(0.0);
        this.networkNodes = RegulatoryNetworkLib.parseYEdFile(file, this.timeIndex);
        this.notifyObserversOfChangedNetwork();
    }

    public DoubleValue getTimeIndex() {
        return this.timeIndex;
    }

    public boolean isEmpty() {
        return this.nodeCount() == 0;
    }

    public int nodeCount() {
        return this.networkNodes.length;
    }

    public void reset() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.reset();
            node.resetLog();
            ++n2;
        }
        this.timeIndex.setValue(0.0);
        this.notifyObserversOfChangedValues();
    }

    public void log() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.log();
            ++n2;
        }
    }

    public HashSet<RegulatoryNetworkObserver> getObservers() {
        return this.observers;
    }

    public void setObservers(HashSet<RegulatoryNetworkObserver> observers) {
        if (observers == null) {
            throw new NullPointerException();
        }
        this.observers = observers;
    }

    public RegulatoryNetwork cloneWithoutObserversAndLogAndANewTimeIndex() {
        DoubleValue timeIndex = new DoubleValue(0.0);
        NetworkNode[] copiedNetworkNodes = new NetworkNode[this.nodeCount()];
        int i = 0;
        while (i < copiedNetworkNodes.length) {
            copiedNetworkNodes[i] = this.networkNodes[i].clone(timeIndex, false);
            ++i;
        }
        return new RegulatoryNetwork(copiedNetworkNodes, timeIndex);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        double[] dArray = this.getValues();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double o = dArray[n2];
            result.append(String.valueOf(StandardNumberFormat.SHORTFIXEDNUMBERFORMAT.format(o)) + " | ");
            ++n2;
        }
        return result.toString();
    }

    public int sumOfInputs() {
        int numberOfInputs = 0;
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            numberOfInputs += node.getInputs().length;
            ++n2;
        }
        return numberOfInputs;
    }

    public void removeAllPerturbations() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.getPerturbations().clear();
            ++n2;
        }
    }
}

