/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.charts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.swing.JPanel;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.binaryrn.RegulatoryNetworkObserver;
import jimena.gui.charts.NodeList;

public class ChartsPanel
extends JPanel
implements RegulatoryNetworkObserver {
    private static final long serialVersionUID = 1851853418701407907L;
    private static final Color[] colors = new Color[]{new Color(0x990000), new Color(0xFF0000), new Color(0xFF6633), new Color(0xFFCC00), new Color(0xFFFF00), new Color(626700), new Color(65280), new Color(52428), new Color(13311), new Color(65535), new Color(153), new Color(0x660099), new Color(0xFF0099), new Color(0xFF66FF), new Color(0x999999)};
    private RegulatoryNetwork network;
    private static final double BD = 30.0;
    private NodeList nodeList;

    public ChartsPanel(RegulatoryNetwork network, NodeList nodeList) {
        if (network == null || nodeList == null) {
            throw new NullPointerException();
        }
        this.network = network;
        network.addObserver(this);
        this.nodeList = nodeList;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        try {
            NetworkNode[] displayedNodes = this.nodeList.getSelectedNodes();
            Graphics2D gg = (Graphics2D)g;
            gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            gg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            gg.setColor(Color.WHITE);
            gg.fill(gg.getClip());
            if (this.network.isEmpty()) {
                return;
            }
            if (this.network.getNetworkNodes()[0].getLog().size() < 2) {
                return;
            }
            double lastTimeIndex = this.network.getNetworkNodes()[0].getLog().get(this.network.getNetworkNodes()[0].getLog().size() - 1).getX();
            AffineTransform transform = new AffineTransform();
            transform.translate(30.0, (double)this.getHeight() - 30.0);
            transform.scale(((double)this.getWidth() - 60.0) / lastTimeIndex, -((double)this.getHeight() - 60.0));
            gg.setColor(new Color(0x444444));
            gg.setStroke(new BasicStroke(1.2f));
            Path2D.Double axes = new Path2D.Double();
            axes.moveTo(lastTimeIndex, 0.0);
            axes.lineTo(0.0, 0.0);
            axes.lineTo(0.0, 1.0);
            axes.transform(transform);
            gg.draw(axes);
            Path2D.Double steps = new Path2D.Double();
            NumberFormat numberFormat = NumberFormat.getNumberInstance();
            numberFormat.setMaximumFractionDigits(3);
            double xStep = ChartsPanel.stepSize((double)this.getWidth() - 60.0, lastTimeIndex, 90.0);
            double xPos = 0.0;
            while (xPos + xStep <= lastTimeIndex) {
                Point2D linePosition = transform.transform(new Point2D.Double(xPos += xStep, 0.0), null);
                steps.moveTo(linePosition.getX(), linePosition.getY() + -2.0);
                steps.lineTo(linePosition.getX(), linePosition.getY() + 2.0);
                FontMetrics metrics = gg.getFontMetrics();
                double descriptionWidth = metrics.stringWidth(numberFormat.format(xPos));
                Point2D.Double position = new Point2D.Double(linePosition.getX() - descriptionWidth / 2.0, linePosition.getY() + 15.0);
                gg.drawString(numberFormat.format(xPos), (float)position.getX(), (float)position.getY());
            }
            gg.draw(steps);
            steps = new Path2D.Double();
            numberFormat.setMaximumFractionDigits(2);
            numberFormat.setMinimumFractionDigits(2);
            double yStep = ChartsPanel.stepSize((double)this.getHeight() - 60.0, 1.0, 90.0);
            double yPos = 0.0;
            while (yPos + yStep <= 1.0001) {
                Point2D linePosition = transform.transform(new Point2D.Double(0.0, yPos += yStep), null);
                steps.moveTo(-2.0 + linePosition.getX(), yPos + linePosition.getY());
                steps.lineTo(2.0 + linePosition.getX(), yPos + linePosition.getY());
                FontMetrics metrics = gg.getFontMetrics();
                double descriptionWidth = metrics.stringWidth(numberFormat.format(yPos));
                Point2D.Double position = new Point2D.Double(linePosition.getX() + (-16.0 - descriptionWidth / 2.0), linePosition.getY() + 3.0);
                gg.drawString(numberFormat.format(yPos), (float)position.getX(), (float)position.getY());
            }
            gg.draw(steps);
            double maxNodeNameWidth = 0.0;
            NetworkNode[] networkNodeArray = displayedNodes;
            int n = displayedNodes.length;
            int n2 = 0;
            while (n2 < n) {
                NetworkNode node = networkNodeArray[n2];
                FontMetrics metrics = gg.getFontMetrics();
                double nodeNameWidth = metrics.stringWidth(node.getName());
                maxNodeNameWidth = Math.max(nodeNameWidth, maxNodeNameWidth);
                ++n2;
            }
            gg.setStroke(new BasicStroke(2.0f));
            int nodeIndex = 0;
            NetworkNode[] networkNodeArray2 = displayedNodes;
            int n3 = displayedNodes.length;
            n = 0;
            while (n < n3) {
                NetworkNode node = networkNodeArray2[n];
                gg.setColor(colors[nodeIndex % colors.length]);
                if (node.getLog().size() >= 2) {
                    Path2D.Double path = new Path2D.Double();
                    path.moveTo(node.getLog().get(0).getX(), node.getLog().get(0).getY());
                    double logStep = ChartsPanel.logStep(node.getLog().size(), (double)this.getWidth() - 60.0, 2.0);
                    double i = 1.0;
                    while ((int)i < node.getLog().size()) {
                        path.lineTo(node.getLog().get((int)i).getX(), node.getLog().get((int)i).getY());
                        i += logStep;
                    }
                    path.transform(transform);
                    gg.draw(path);
                    ++nodeIndex;
                }
                ++n;
            }
            nodeIndex = 0;
            networkNodeArray2 = displayedNodes;
            n3 = displayedNodes.length;
            n = 0;
            while (n < n3) {
                NetworkNode node = networkNodeArray2[n];
                gg.setColor(colors[nodeIndex % colors.length]);
                gg.fill(new Rectangle2D.Double((double)this.getWidth() - maxNodeNameWidth - 40.0, 10 + 20 * nodeIndex, 10.0, 10.0));
                gg.setColor(Color.black);
                gg.drawString(node.getName(), (int)((double)this.getWidth() - maxNodeNameWidth - 22.0), 18 + 20 * nodeIndex);
                ++nodeIndex;
                ++n;
            }
        }
        catch (IndexOutOfBoundsException e) {
            Graphics2D gg = (Graphics2D)g;
            gg.setColor(Color.WHITE);
            gg.fill(gg.getClip());
        }
        catch (NullPointerException e) {
            Graphics2D gg = (Graphics2D)g;
            gg.setColor(Color.WHITE);
            gg.fill(gg.getClip());
        }
    }

    @Override
    public void notifyNetworkChanged() {
        this.notifyValuesChanged();
    }

    @Override
    public void notifyValuesChanged() {
        this.repaint();
    }

    private static double stepSize(double pixelLength, double length, double maxPixelPerStep) {
        double logicalStep = 1000000.0;
        while (pixelLength / (length / logicalStep) > maxPixelPerStep) {
            logicalStep /= 10.0;
        }
        if (pixelLength / (length / (5.0 * logicalStep)) <= maxPixelPerStep) {
            return logicalStep * 5.0;
        }
        if (pixelLength / (length / (2.0 * logicalStep)) <= maxPixelPerStep) {
            return logicalStep * 2.0;
        }
        return logicalStep;
    }

    private static double logStep(double numberOfLogEntries, double abscissaPixelLength, double abscissaPixelPerStep) {
        return Math.max(numberOfLogEntries / (abscissaPixelLength / abscissaPixelPerStep), 1.0);
    }
}

