/*
 * Decompiled with CFR 0.152.
 */
package jimena.libs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jimena.libs.MathLib;

public class ArrayLib {
    public static ArrayList<Object[]> bytesListToObjectsListUnchecked(ArrayList<byte[]> data) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (byte[] byteArray : data) {
            Object[] objectArray = new Object[byteArray.length];
            int i = 0;
            while (i < byteArray.length) {
                objectArray[i] = byteArray[i];
                ++i;
            }
            result.add(objectArray);
        }
        return result;
    }

    public static ArrayList<Object[]> doublesListToObjectsListUnchecked(List<double[]> data) {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        for (double[] byteArray : data) {
            Object[] objectArray = new Object[byteArray.length];
            int i = 0;
            while (i < byteArray.length) {
                objectArray[i] = byteArray[i];
                ++i;
            }
            result.add(objectArray);
        }
        return result;
    }

    public static <T> T[] add(T[] array, T newElement) {
        if (array == null || newElement == null) {
            throw new NullPointerException();
        }
        T[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = newElement;
        return newArray;
    }

    public static <T> void swap(List<T> list, int a, int b) {
        T temp = list.get(a);
        list.set(a, list.get(b));
        list.set(b, temp);
    }

    public static <T> void swap(List<T> list) {
        int a = MathLib.randomInt(list.size() - 1);
        int b = MathLib.randomInt(list.size() - 1);
        ArrayLib.swap(list, a, b);
    }
}

