/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf.treebf;

import jimena.binarybf.treebf.BinaryNode;
import jimena.binarybf.treebf.TreeNode;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class ANDBinaryNode
extends BinaryNode {
    private static final long serialVersionUID = -1890836409857875885L;

    public ANDBinaryNode(TreeNode leaf1, TreeNode leaf2) {
        super(leaf1, leaf2);
    }

    public ANDBinaryNode(TreeNode leaf1, TreeNode leaf2, boolean disabled) {
        super(leaf1, leaf2, disabled);
    }

    @Override
    protected boolean evalNode(boolean a, boolean b) {
        if (this.leaf1.isDisabled()) {
            return b;
        }
        if (this.leaf2.isDisabled()) {
            return a;
        }
        if (this.leaf1.isDisabled() && this.leaf2.isDisabled()) {
            throw new ArithmeticException("A binary node with two disabled subtrees cannot be evaluated.");
        }
        return a && b;
    }

    @Override
    public double interpolateBooleCube(double[] inputs) {
        if (this.leaf1.isDisabled()) {
            return this.leaf2.interpolateBooleCube(inputs);
        }
        if (this.leaf2.isDisabled()) {
            return this.leaf1.interpolateBooleCube(inputs);
        }
        if (this.leaf1.isDisabled() && this.leaf2.isDisabled()) {
            throw new ArithmeticException("A binary node with two disabled subtrees cannot be evaluated.");
        }
        return this.leaf1.interpolateBooleCube(inputs) * this.leaf2.interpolateBooleCube(inputs);
    }

    @Override
    public ANDBinaryNode clone() {
        return new ANDBinaryNode(this.leaf1.clone(), this.leaf2.clone(), this.isDisabled());
    }

    @Override
    protected BDD createBDD(BDD[] inputs, BDDFactory bddFactory) {
        if (this.leaf1.isDisabled()) {
            return this.leaf2.createBDD(inputs, bddFactory);
        }
        if (this.leaf2.isDisabled()) {
            return this.leaf1.createBDD(inputs, bddFactory);
        }
        if (this.leaf1.isDisabled() && this.leaf2.isDisabled()) {
            throw new ArithmeticException("A binary node with two disabled subtrees cannot be evaluated.");
        }
        return this.leaf1.createBDD(inputs, bddFactory).and(this.leaf2.createBDD(inputs, bddFactory));
    }

    @Override
    public String toString() {
        return "(" + this.leaf1.toString() + " AND " + this.leaf2.toString() + ")";
    }

    @Override
    public String getFunctionString(String[] nodeNames, boolean odefyCompatible) {
        if (this.leaf1.isDisabled()) {
            return this.leaf2.getFunctionString(nodeNames, odefyCompatible);
        }
        if (this.leaf2.isDisabled()) {
            return this.leaf1.getFunctionString(nodeNames, odefyCompatible);
        }
        if (this.leaf1.isDisabled() && this.leaf2.isDisabled()) {
            throw new ArithmeticException("A binary node with two disabled subtrees cannot be evaluated.");
        }
        return "(" + this.leaf1.getFunctionString(nodeNames, odefyCompatible) + (odefyCompatible ? " && " : " AND ") + this.leaf2.getFunctionString(nodeNames, odefyCompatible) + ")";
    }
}

