/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulation;

import javax.swing.JOptionPane;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.libs.ChecksLib;
import jimena.libs.MathLib;
import jimena.simulation.SSSFromStartVector;
import jimena.simulationmethods.SimulationMethod;

public class SimulatedAnnealingSSS
extends SSSFromStartVector {
    private RegulatoryNetwork network;
    private SimulationMethod method;
    private long maxt;

    public SimulatedAnnealingSSS(RegulatoryNetwork network, SimulationMethod method, long maximumSteps) {
        ChecksLib.checkNotNull(network, method);
        if (maximumSteps <= 0L) {
            throw new IllegalArgumentException("The maximum number of steps must be positive.");
        }
        this.network = network;
        this.method = method;
        this.maxt = maximumSteps;
    }

    @Override
    public void run() {
        if (this.network.nodeCount() == 0) {
            this.result = new double[0];
            return;
        }
        try {
            long t = 0L;
            double eResult = Double.MAX_VALUE;
            while (t <= this.maxt) {
                double temp = Math.exp(-((double)t) / (double)(this.maxt / 10L));
                double[] oldVector = this.network.getValues();
                double eOld = this.method.stateStabilityIndex(this.network);
                double[] newVector = SimulatedAnnealingSSS.neighbor(oldVector);
                this.network.setValues(newVector);
                double eNew = this.method.stateStabilityIndex(this.network);
                if (eNew <= eResult) {
                    eResult = eNew;
                    this.result = newVector;
                }
                if (!(eNew <= eOld) && !(Math.random() < Math.exp(-(eNew - eOld) / temp))) {
                    this.network.setValues(oldVector);
                }
                ++t;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Simulation failed", 0);
        }
    }

    private static double[] neighbor(double[] vector) {
        double[] result = (double[])vector.clone();
        int component = MathLib.randomInt(result.length - 1);
        result[component] = Math.random();
        return result;
    }
}

