/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulation;

import javax.swing.JOptionPane;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.SSSSearchParameters;
import jimena.libs.ChecksLib;
import jimena.simulation.CalculationController;
import jimena.simulation.SSSFromStartVector;
import jimena.simulationmethods.SimulationMethod;

public class StableSteadyState
extends SSSFromStartVector {
    private RegulatoryNetwork network;
    private SimulationMethod method;
    private double dt;
    private double maxt;
    private double stabilityMaxDiff;
    private double stabilityMinTime;
    private CalculationController calculationController = null;
    private static final long minTimeBetweenNotifications = 50L;

    public StableSteadyState(RegulatoryNetwork network, SSSSearchParameters p) {
        this(network, p.getMethod(), p.getDt(), p.getMaxT(), p.getStabilityMaxDiff(), p.getStabilityMinTime(), p.getCalculationController());
    }

    public StableSteadyState(RegulatoryNetwork network, SimulationMethod method, double dt, double maxt, double stabilityMaxDiff, double stabilityMinTime, CalculationController calculationController) {
        ChecksLib.checkNotNull(network, method);
        if (dt <= 0.0 || maxt <= 0.0 || stabilityMaxDiff <= 0.0 || stabilityMinTime <= 0.0) {
            throw new IllegalArgumentException("All numerical inputs to the constuctor of a StableSteadyState must positive.");
        }
        this.network = network;
        this.method = method;
        this.dt = dt;
        this.maxt = maxt;
        this.stabilityMaxDiff = stabilityMaxDiff;
        this.stabilityMinTime = stabilityMinTime;
        this.calculationController = calculationController;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        double t = 0.0;
        if (this.network.nodeCount() == 0) {
            return;
        }
        try {
            try {
                double lastStabilityCheckPoint = 0.0;
                int stepsDone = 0;
                long lastNotification = System.currentTimeMillis();
                double[] valuesAtLastStabilityCheckPoint = this.network.getValues();
                boolean StabilityCheckFailed = false;
                while (t <= this.maxt) {
                    if (this.calculationController != null && !this.calculationController.isOn()) {
                        return;
                    }
                    this.method.stepUpdateNetwork(this.network, this.dt);
                    if (!StabilityCheckFailed) {
                        int i = 0;
                        while (i < this.network.nodeCount()) {
                            if (Math.abs(this.network.getNetworkNodes()[i].getValue() - valuesAtLastStabilityCheckPoint[i]) > this.stabilityMaxDiff) {
                                StabilityCheckFailed = true;
                            }
                            ++i;
                        }
                    }
                    if (t - lastStabilityCheckPoint >= this.stabilityMinTime) {
                        if (!StabilityCheckFailed) {
                            this.result = this.network.getValues();
                            return;
                        }
                        valuesAtLastStabilityCheckPoint = (double[])this.network.getValues().clone();
                        StabilityCheckFailed = false;
                        lastStabilityCheckPoint = t;
                    }
                    t += this.dt;
                    ++stepsDone;
                    if (this.calculationController == null || System.currentTimeMillis() - lastNotification < 50L) continue;
                    this.calculationController.setProgress(t / this.maxt, stepsDone);
                    lastNotification = System.currentTimeMillis();
                }
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "Simulation failed", 0);
                if (this.calculationController != null) {
                    this.calculationController.notifyCalculationFinished();
                }
                this.convergingTime = t;
                return;
            }
        }
        finally {
            if (this.calculationController != null) {
                this.calculationController.notifyCalculationFinished();
            }
            this.convergingTime = t;
        }
    }
}

