/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf.treebf;

import java.util.LinkedList;
import jimena.binarybf.treebf.TreeNode;

public abstract class BinaryNode
extends TreeNode {
    private static final long serialVersionUID = -3569782960854244159L;
    protected TreeNode leaf1;
    protected TreeNode leaf2;

    public BinaryNode(TreeNode leaf1, TreeNode leaf2) {
        if (leaf1 == null || leaf2 == null) {
            throw new NullPointerException();
        }
        this.leaf1 = leaf1;
        this.leaf2 = leaf2;
        if (this.isCyclic()) {
            throw new IllegalArgumentException("The tree of a boolean function must be a acyclic.");
        }
    }

    public BinaryNode(TreeNode leaf1, TreeNode leaf2, boolean disabled) {
        this(leaf1, leaf2);
        this.setDisabled(disabled);
    }

    @Override
    public boolean eval(boolean[] inputs) {
        return this.evalNode(this.leaf1.eval(inputs), this.leaf2.eval(inputs));
    }

    protected abstract boolean evalNode(boolean var1, boolean var2);

    @Override
    public int getMinArity() {
        return Math.max(this.leaf1.getMinArity(), this.leaf2.getMinArity());
    }

    @Override
    protected boolean isCyclic(LinkedList<TreeNode> predecessors) {
        if (predecessors.contains(this)) {
            return true;
        }
        predecessors.add(this);
        boolean result = this.leaf1.isCyclic(predecessors) || this.leaf2.isCyclic(predecessors);
        predecessors.removeLast();
        return result;
    }

    @Override
    public void disableInput(int position) {
        this.leaf1.disableInput(position);
        this.leaf2.disableInput(position);
        this.setDisabled(this.leaf1.isDisabled() && this.leaf2.isDisabled());
    }
}

