/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.main;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import javax.swing.JPanel;
import jimena.binarybf.actinhibitf.ActivatorInhibitorFunction;
import jimena.binaryrn.Input;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.binaryrn.RegulatoryNetworkObserver;
import jimena.gui.main.HasActivatableNodes;
import jimena.libs.MathLib;

public class PanelGraphDrawer
extends JPanel
implements RegulatoryNetworkObserver {
    private static final long serialVersionUID = 6827002870716796773L;
    private static final double NODEPADDING = 50.0;
    private static final double ARROWTIPANGLE = 0.45;
    private static final double ARROWTIPLENGTH = 13.0;
    private static final double NODERECTANGLEROUNDING = 10.0;
    private static final double NEGATINGARROWWIDTH = 9.0;
    private static final double NEGATINGARROWTHICKNESS = 5.0;
    private RegulatoryNetwork network = new RegulatoryNetwork();
    private BufferedImage background = new BufferedImage(1, 1, 6);
    private Graphics2D backgroundGraphics = (Graphics2D)this.background.getGraphics();
    private HasActivatableNodes leftClickListener;
    private HasActivatableNodes rightClickListener;

    @Override
    public void notifyValuesChanged() {
        this.repaint();
    }

    public PanelGraphDrawer(RegulatoryNetwork network, HasActivatableNodes leftClickListener, HasActivatableNodes rightClickListener) {
        if (network == null || leftClickListener == null || rightClickListener == null) {
            throw new NullPointerException();
        }
        this.network = network;
        this.leftClickListener = leftClickListener;
        this.rightClickListener = rightClickListener;
        network.addObserver(this);
        this.notifyNetworkChanged();
        this.setBackground(Color.white);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                Point clickPoint = e.getPoint();
                try {
                    PanelGraphDrawer.this.backgroundGraphics.getTransform().inverseTransform(clickPoint, clickPoint);
                }
                catch (NoninvertibleTransformException e1) {
                    e1.printStackTrace();
                }
                int i = 0;
                while (i < PanelGraphDrawer.this.network.nodeCount()) {
                    NetworkNode node = PanelGraphDrawer.this.network.getNetworkNodes()[i];
                    Rectangle2D.Double nodeRect = node.getRectangle();
                    if (nodeRect.contains(clickPoint)) {
                        if (e.getButton() == 1) {
                            PanelGraphDrawer.this.leftClickListener.activateNode(i);
                        }
                        if (e.getButton() == 3) {
                            PanelGraphDrawer.this.rightClickListener.activateNode(i);
                        }
                        return;
                    }
                    ++i;
                }
            }
        });
    }

    @Override
    public void notifyNetworkChanged() {
        int n;
        int n2;
        Serializable[] serializableArray;
        if (this.network.nodeCount() == 0) {
            this.background = new BufferedImage(1, 1, 6);
            return;
        }
        Rectangle2D.Double dimensions = (Rectangle2D.Double)this.network.getNetworkNodes()[0].getRectangle().clone();
        NetworkNode[] networkNodeArray = this.network.getNetworkNodes();
        int n3 = networkNodeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            NetworkNode node = networkNodeArray[n4];
            dimensions.add(node.getRectangle());
            serializableArray = node.getInputs();
            n2 = serializableArray.length;
            n = 0;
            while (n < n2) {
                Input input = serializableArray[n];
                Point2D.Double[] doubleArray = input.getPath();
                int n5 = doubleArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Point2D.Double point = doubleArray[n6];
                    dimensions.add(point);
                    ++n6;
                }
                ++n;
            }
            ++n4;
        }
        double width = dimensions.getWidth() + 100.0;
        double height = dimensions.getHeight() + 100.0;
        this.background = new BufferedImage((int)width, (int)height, 6);
        this.backgroundGraphics = (Graphics2D)this.background.getGraphics();
        this.backgroundGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.backgroundGraphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.backgroundGraphics.setColor(Color.white);
        this.backgroundGraphics.fillRect(0, 0, this.background.getWidth(), this.background.getHeight());
        this.backgroundGraphics.translate(-(dimensions.getX() - 50.0), -(dimensions.getY() - 50.0));
        this.backgroundGraphics.setStroke(new BasicStroke(1.5f));
        this.backgroundGraphics.setColor(new Color(0, 0, 0));
        serializableArray = this.network.getNetworkNodes();
        n2 = serializableArray.length;
        n = 0;
        while (n < n2) {
            Serializable node = serializableArray[n];
            int i = 0;
            while (i < ((NetworkNode)node).getInputs().length) {
                Input input = ((NetworkNode)node).getInputs()[i];
                boolean inhib = false;
                if (((NetworkNode)node).getFunction() instanceof ActivatorInhibitorFunction) {
                    inhib = !((ActivatorInhibitorFunction)((NetworkNode)node).getFunction()).getActivators()[i];
                }
                this.drawInputArrow(this.backgroundGraphics, this.network.getNetworkNodes()[input.getSource()], (NetworkNode)node, input, inhib);
                ++i;
            }
            ++n;
        }
        this.setPreferredSize(new Dimension(this.background.getWidth(), this.background.getHeight()));
        this.revalidate();
        this.notifyValuesChanged();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D gg = (Graphics2D)g;
        gg.drawImage((Image)this.background, 0, 0, null);
        gg.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        gg.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        AffineTransform transform = new AffineTransform(this.backgroundGraphics.getTransform());
        transform.concatenate(gg.getTransform());
        gg.setTransform(transform);
        gg.setStroke(new BasicStroke(2.0f));
        NetworkNode[] networkNodeArray = this.network.getNetworkNodes();
        int n = networkNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            Rectangle2D.Double rect = node.getRectangle();
            RoundRectangle2D.Double roundedRect = new RoundRectangle2D.Double(((RectangularShape)rect).getX(), ((RectangularShape)rect).getY(), ((RectangularShape)rect).getWidth(), ((RectangularShape)rect).getHeight(), 10.0, 10.0);
            float color = (float)(1.0 - node.getValue() * 0.5);
            gg.setColor(new Color(color, color, color));
            gg.fill(roundedRect);
            gg.setColor(new Color(0, 0, 0));
            gg.draw(roundedRect);
            FontMetrics metrics = gg.getFontMetrics();
            double labelWidth = metrics.stringWidth(node.getName());
            double labelHeight = metrics.getHeight();
            gg.setColor(new Color(0, 0, 0));
            gg.drawString(node.getName(), (float)(((RectangularShape)rect).getX() + ((RectangularShape)rect).getWidth() / 2.0 - labelWidth / 2.0), (float)(((RectangularShape)rect).getY() + ((RectangularShape)rect).getHeight() / 2.0 + labelHeight / 2.0 - 3.0));
            ++n2;
        }
    }

    private void drawInputArrow(Graphics2D g, NetworkNode source, NetworkNode target, Input input, boolean inhib) {
        Path2D.Double arrowLine = new Path2D.Double();
        Point2D.Double firstPoint = MathLib.addPointsUnchecked(MathLib.getRectCenterUnchecked(source.getRectangle()), input.getPathOrigin());
        arrowLine.moveTo(firstPoint.getX(), firstPoint.getY());
        Point2D.Double s = null;
        if (input.getPath().length != 0) {
            Point2D.Double[] doubleArray = input.getPath();
            int n = doubleArray.length;
            int n2 = 0;
            while (n2 < n) {
                Point2D.Double point = doubleArray[n2];
                arrowLine.lineTo(point.getX(), point.getY());
                s = point;
                ++n2;
            }
        } else {
            s = firstPoint;
        }
        g.draw(arrowLine);
        Point2D.Double t = MathLib.lineIntersectRectUnchecked(target.getRectangle(), s, MathLib.addPointsUnchecked(MathLib.getRectCenterUnchecked(target.getRectangle()), input.getPathTarget()));
        this.drawArrow(g, s, t, inhib);
    }

    private void drawArrow(Graphics2D g, Point2D.Double source, Point2D.Double target, boolean inhib) {
        double relx = target.getX() - source.getX();
        double rely = target.getY() - source.getY();
        double arrowAngle = Math.atan2(rely, relx);
        if (!inhib) {
            double arrowtipangle = 0.45;
            double x1 = -Math.cos(arrowAngle + arrowtipangle) * 13.0 + target.getX();
            double y1 = -Math.sin(arrowAngle + arrowtipangle) * 13.0 + target.getY();
            double x2 = -Math.cos(arrowAngle - arrowtipangle) * 13.0 + target.getX();
            double y2 = -Math.sin(arrowAngle - arrowtipangle) * 13.0 + target.getY();
            Path2D.Double triangle = new Path2D.Double();
            triangle.moveTo(target.getX(), target.getY());
            triangle.lineTo(x1, y1);
            triangle.lineTo(x2, y2);
            g.fill(triangle);
        } else {
            double x1 = -Math.cos(arrowAngle + 1.5707963267948966) * 9.0 + target.getX();
            double y1 = -Math.sin(arrowAngle + 1.5707963267948966) * 9.0 + target.getY();
            double x2 = -Math.cos(arrowAngle - 1.5707963267948966) * 9.0 + target.getX();
            double y2 = -Math.sin(arrowAngle - 1.5707963267948966) * 9.0 + target.getY();
            double x3 = Math.cos(arrowAngle + Math.PI) * 5.0 + x1;
            double y3 = Math.sin(arrowAngle + Math.PI) * 5.0 + y1;
            double x4 = Math.cos(arrowAngle + Math.PI) * 5.0 + x2;
            double y4 = Math.sin(arrowAngle + Math.PI) * 5.0 + y2;
            Path2D.Double triangle = new Path2D.Double();
            triangle.moveTo(x1, y1);
            triangle.lineTo(x2, y2);
            triangle.lineTo(x4, y4);
            triangle.lineTo(x3, y3);
            g.fill(triangle);
        }
        g.draw(new Line2D.Double(source, target));
    }
}

