/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JOptionPane;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.libs.ArrayLib;
import jimena.libs.ChecksLib;
import jimena.libs.MathLib;
import jimena.simulationmethods.SimulationMethod;

public class GeneticSSS
extends Thread {
    private RegulatoryNetwork network;
    private SimulationMethod method;
    private long maxt;
    private int solutions;
    private ArrayList<double[]> results = null;

    public GeneticSSS(RegulatoryNetwork network, SimulationMethod method, long maxt, int solutions) {
        ChecksLib.checkNotNull(network, method);
        if (maxt <= 0L) {
            throw new IllegalArgumentException("Maxt must be positive.");
        }
        if (solutions <= 0) {
            throw new IllegalArgumentException("The number of solutions must be positive.");
        }
        this.network = network;
        this.method = method;
        this.maxt = maxt;
        this.solutions = solutions;
    }

    public ArrayList<double[]> getResults() {
        return this.results;
    }

    @Override
    public void run() {
        if (this.network.nodeCount() == 0) {
            this.results = new ArrayList();
            return;
        }
        try {
            ArrayList<RegulatoryNetwork> instances = new ArrayList<RegulatoryNetwork>();
            int i = 0;
            while (i < this.solutions) {
                RegulatoryNetwork instance = this.network.cloneClean();
                instance.setValues(MathLib.randomVector(this.network.nodeCount()));
                instances.add(instance);
                ++i;
            }
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() < start + this.maxt) {
                int firstParent = MathLib.randomInt(this.solutions - 1);
                int secondParent = MathLib.randomInt(this.solutions - 1);
                int k = 0;
                while (k < this.solutions) {
                    RegulatoryNetwork instance = this.network.cloneClean();
                    int j = 0;
                    while (j < this.network.nodeCount()) {
                        double whatToDo = Math.random();
                        if (whatToDo < 0.45) {
                            instance.getNetworkNodes()[j].setValue(((RegulatoryNetwork)instances.get(firstParent)).getNetworkNodes()[j].getValue());
                        } else if (whatToDo < 0.9) {
                            instance.getNetworkNodes()[j].setValue(((RegulatoryNetwork)instances.get(secondParent)).getNetworkNodes()[j].getValue());
                        } else {
                            instance.getNetworkNodes()[j].setValue(Math.random());
                        }
                        ++j;
                    }
                    instances.add(instance);
                    ++k;
                }
                Collections.sort(instances, new StateComparator());
                k = 0;
                while (k < this.solutions / 10) {
                    ArrayLib.swap(instances);
                    ++k;
                }
                k = instances.size() - 1;
                while (k >= this.solutions) {
                    instances.remove(k);
                    --k;
                }
            }
            for (RegulatoryNetwork instance : instances) {
                this.results.add(instance.getValues());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, e.getMessage(), "Simulation failed", 0);
        }
    }

    private double meanStability(ArrayList<RegulatoryNetwork> instances) {
        double result = 0.0;
        for (RegulatoryNetwork instance : instances) {
            result += this.method.stateStabilityIndex(instance);
        }
        return result / (double)instances.size();
    }

    public class StateComparator
    implements Comparator<RegulatoryNetwork> {
        @Override
        public int compare(RegulatoryNetwork n0, RegulatoryNetwork n1) {
            double stability1;
            double stability0 = GeneticSSS.this.method.stateStabilityIndex(n0);
            if (stability0 == (stability1 = GeneticSSS.this.method.stateStabilityIndex(n1))) {
                return 0;
            }
            if (stability0 > stability1) {
                return 1;
            }
            return -1;
        }
    }
}

