/*
 * Decompiled with CFR 0.152.
 */
package net.sf.javabdd;

import java.math.BigInteger;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDDomain;
import net.sf.javabdd.BDDException;
import net.sf.javabdd.BDDFactory;

public abstract class BDDBitVector {
    protected BDD[] bitvec;

    protected BDDBitVector(int bitnum) {
        this.bitvec = new BDD[bitnum];
    }

    protected void initialize(boolean isTrue) {
        BDDFactory bdd2 = this.getFactory();
        int n = 0;
        while (n < this.bitvec.length) {
            this.bitvec[n] = isTrue ? bdd2.one() : bdd2.zero();
            ++n;
        }
    }

    protected void initialize(int val) {
        BDDFactory bdd2 = this.getFactory();
        int n = 0;
        while (n < this.bitvec.length) {
            this.bitvec[n] = (val & 1) != 0 ? bdd2.one() : bdd2.zero();
            val >>= 1;
            ++n;
        }
    }

    protected void initialize(long val) {
        BDDFactory bdd2 = this.getFactory();
        int n = 0;
        while (n < this.bitvec.length) {
            this.bitvec[n] = (val & 1L) != 0L ? bdd2.one() : bdd2.zero();
            val >>= 1;
            ++n;
        }
    }

    protected void initialize(BigInteger val) {
        BDDFactory bdd2 = this.getFactory();
        int n = 0;
        while (n < this.bitvec.length) {
            this.bitvec[n] = val.testBit(0) ? bdd2.one() : bdd2.zero();
            val = val.shiftRight(1);
            ++n;
        }
    }

    protected void initialize(int offset, int step) {
        BDDFactory bdd2 = this.getFactory();
        int n = 0;
        while (n < this.bitvec.length) {
            this.bitvec[n] = bdd2.ithVar(offset + n * step);
            ++n;
        }
    }

    protected void initialize(BDDDomain d) {
        this.initialize(d.vars());
    }

    protected void initialize(int[] var) {
        BDDFactory bdd2 = this.getFactory();
        int n = 0;
        while (n < this.bitvec.length) {
            this.bitvec[n] = bdd2.ithVar(var[n]);
            ++n;
        }
    }

    public abstract BDDFactory getFactory();

    public BDDBitVector copy() {
        BDDFactory bdd2 = this.getFactory();
        BDDBitVector dst = bdd2.createBitVector(this.bitvec.length);
        int n = 0;
        while (n < this.bitvec.length) {
            dst.bitvec[n] = this.bitvec[n].id();
            ++n;
        }
        return dst;
    }

    public BDDBitVector coerce(int bitnum) {
        BDDFactory bdd2 = this.getFactory();
        BDDBitVector dst = bdd2.createBitVector(bitnum);
        int minnum = Math.min(bitnum, this.bitvec.length);
        int n = 0;
        while (n < minnum) {
            dst.bitvec[n] = this.bitvec[n].id();
            ++n;
        }
        while (n < minnum) {
            dst.bitvec[n] = bdd2.zero();
            ++n;
        }
        return dst;
    }

    public boolean isConst() {
        int n = 0;
        while (n < this.bitvec.length) {
            BDD b = this.bitvec[n];
            if (!b.isOne() && !b.isZero()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int val() {
        int val = 0;
        int n = this.bitvec.length - 1;
        while (n >= 0) {
            if (this.bitvec[n].isOne()) {
                val = val << 1 | 1;
            } else if (this.bitvec[n].isZero()) {
                val <<= 1;
            } else {
                return 0;
            }
            --n;
        }
        return val;
    }

    public void free() {
        int n = 0;
        while (n < this.bitvec.length) {
            this.bitvec[n].free();
            ++n;
        }
        this.bitvec = null;
    }

    public BDDBitVector map2(BDDBitVector that, BDDFactory.BDDOp op) {
        if (this.bitvec.length != that.bitvec.length) {
            throw new BDDException();
        }
        BDDFactory bdd2 = this.getFactory();
        BDDBitVector res = bdd2.createBitVector(this.bitvec.length);
        int n = 0;
        while (n < this.bitvec.length) {
            res.bitvec[n] = this.bitvec[n].apply(that.bitvec[n], op);
            ++n;
        }
        return res;
    }

    public BDDBitVector add(BDDBitVector that) {
        if (this.bitvec.length != that.bitvec.length) {
            throw new BDDException();
        }
        BDDFactory bdd2 = this.getFactory();
        BDD c = bdd2.zero();
        BDDBitVector res = bdd2.createBitVector(this.bitvec.length);
        int n = 0;
        while (n < res.bitvec.length) {
            res.bitvec[n] = this.bitvec[n].xor(that.bitvec[n]);
            res.bitvec[n].xorWith(c.id());
            BDD tmp1 = this.bitvec[n].or(that.bitvec[n]);
            tmp1.andWith(c);
            BDD tmp2 = this.bitvec[n].and(that.bitvec[n]);
            tmp2.orWith(tmp1);
            c = tmp2;
            ++n;
        }
        c.free();
        return res;
    }

    public BDDBitVector sub(BDDBitVector that) {
        if (this.bitvec.length != that.bitvec.length) {
            throw new BDDException();
        }
        BDDFactory bdd2 = this.getFactory();
        BDD c = bdd2.zero();
        BDDBitVector res = bdd2.createBitVector(this.bitvec.length);
        int n = 0;
        while (n < res.bitvec.length) {
            res.bitvec[n] = this.bitvec[n].xor(that.bitvec[n]);
            res.bitvec[n].xorWith(c.id());
            BDD tmp1 = that.bitvec[n].or(c);
            BDD tmp2 = this.bitvec[n].apply(tmp1, BDDFactory.less);
            tmp1.free();
            tmp1 = this.bitvec[n].and(that.bitvec[n]);
            tmp1.andWith(c);
            tmp1.orWith(tmp2);
            c = tmp1;
            ++n;
        }
        c.free();
        return res;
    }

    BDD lte(BDDBitVector r) {
        if (this.bitvec.length != r.bitvec.length) {
            throw new BDDException();
        }
        BDDFactory bdd2 = this.getFactory();
        BDD p = bdd2.one();
        int n = 0;
        while (n < this.bitvec.length) {
            BDD tmp1 = this.bitvec[n].apply(r.bitvec[n], BDDFactory.less);
            BDD tmp2 = this.bitvec[n].apply(r.bitvec[n], BDDFactory.biimp);
            tmp2.andWith(p);
            tmp1.orWith(tmp2);
            p = tmp1;
            ++n;
        }
        return p;
    }

    static void div_rec(BDDBitVector divisor, BDDBitVector remainder, BDDBitVector result, int step) {
        BDD isSmaller = divisor.lte(remainder);
        BDDBitVector newResult = result.shl(1, isSmaller);
        BDDFactory bdd2 = divisor.getFactory();
        BDDBitVector zero = bdd2.buildVector(divisor.bitvec.length, false);
        BDDBitVector sub = bdd2.buildVector(divisor.bitvec.length, false);
        int n = 0;
        while (n < divisor.bitvec.length) {
            sub.bitvec[n] = isSmaller.ite(divisor.bitvec[n], zero.bitvec[n]);
            ++n;
        }
        BDDBitVector tmp = remainder.sub(sub);
        BDDBitVector newRemainder = tmp.shl(1, result.bitvec[divisor.bitvec.length - 1]);
        if (step > 1) {
            BDDBitVector.div_rec(divisor, newRemainder, newResult, step - 1);
        }
        tmp.free();
        sub.free();
        zero.free();
        isSmaller.free();
        result.replaceWith(newResult);
        remainder.replaceWith(newRemainder);
    }

    public void replaceWith(BDDBitVector that) {
        if (this.bitvec.length != that.bitvec.length) {
            throw new BDDException();
        }
        this.free();
        this.bitvec = that.bitvec;
        that.bitvec = null;
    }

    public BDDBitVector shl(int pos, BDD c) {
        int minnum = Math.min(this.bitvec.length, pos);
        if (minnum < 0) {
            throw new BDDException();
        }
        BDDFactory bdd2 = this.getFactory();
        BDDBitVector res = bdd2.createBitVector(this.bitvec.length);
        int n = 0;
        while (n < minnum) {
            res.bitvec[n] = c.id();
            ++n;
        }
        n = minnum;
        while (n < this.bitvec.length) {
            res.bitvec[n] = this.bitvec[n - pos].id();
            ++n;
        }
        return res;
    }

    BDDBitVector shr(int pos, BDD c) {
        int maxnum = Math.max(0, this.bitvec.length - pos);
        if (maxnum < 0) {
            throw new BDDException();
        }
        BDDFactory bdd2 = this.getFactory();
        BDDBitVector res = bdd2.createBitVector(this.bitvec.length);
        int n = maxnum;
        while (n < this.bitvec.length) {
            res.bitvec[n] = c.id();
            ++n;
        }
        n = 0;
        while (n < maxnum) {
            res.bitvec[n] = this.bitvec[n + pos].id();
            ++n;
        }
        return res;
    }

    public BDDBitVector divmod(long c, boolean which) {
        if (c <= 0L) {
            throw new BDDException();
        }
        BDDFactory bdd2 = this.getFactory();
        BDDBitVector divisor = bdd2.constantVector(this.bitvec.length, c);
        BDDBitVector tmp = bdd2.buildVector(this.bitvec.length, false);
        BDDBitVector tmpremainder = tmp.shl(1, this.bitvec[this.bitvec.length - 1]);
        BDDBitVector result = this.shl(1, bdd2.zero());
        BDDBitVector.div_rec(divisor, tmpremainder, result, divisor.bitvec.length);
        BDDBitVector remainder = tmpremainder.shr(1, bdd2.zero());
        tmp.free();
        tmpremainder.free();
        divisor.free();
        if (which) {
            remainder.free();
            return result;
        }
        result.free();
        return remainder;
    }

    public int size() {
        return this.bitvec.length;
    }

    public BDD getBit(int n) {
        return this.bitvec[n];
    }
}

