/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf.actinhibitf;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binarybf.treebf.TreeBooleanFunction;
import jimena.libs.MathLib;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class ActivatorInhibitorFunction
extends BinaryBooleanFunction {
    private static final long serialVersionUID = -1756565073860160320L;
    private boolean[] activators;
    private boolean[] disabled;
    private TreeBooleanFunction treeBooleanFunction = null;
    private boolean wasMutated = false;

    public ActivatorInhibitorFunction(boolean[] activators, boolean[] disabled) {
        this(activators);
        if (disabled.length != activators.length) {
            throw new IllegalArgumentException("The length of the activators arrays must correspond to the length of the disabled array");
        }
        this.disabled = disabled;
        this.treeBooleanFunction = new TreeBooleanFunction(activators);
        int i = 0;
        while (i < disabled.length) {
            if (disabled[i]) {
                this.treeBooleanFunction.disableInput(i);
            }
            ++i;
        }
    }

    public ActivatorInhibitorFunction(boolean[] activators) {
        if (activators == null) {
            throw new NullPointerException("Please provide an empty array to create the nullary constant false function.");
        }
        this.activators = activators;
        this.disabled = new boolean[activators.length];
        this.treeBooleanFunction = new TreeBooleanFunction(activators);
    }

    @Override
    public boolean eval(boolean[] values) {
        boolean result = false;
        int i = 0;
        while (i < this.activators.length) {
            if (!this.disabled[i] && this.activators[i] && values[i]) {
                result = true;
                break;
            }
            ++i;
        }
        if (!result) {
            return false;
        }
        i = 0;
        while (i < this.activators.length) {
            if (!this.disabled[i] && !this.activators[i] && values[i]) {
                return false;
            }
            ++i;
        }
        return result;
    }

    @Override
    public int getArity() {
        return this.activators.length;
    }

    private boolean onlyInhibitors(boolean[] activators, boolean[] disabled) {
        int i = 0;
        while (i < activators.length) {
            if (activators[i] && !disabled[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean onlyActivators(boolean[] activators, boolean[] disabled) {
        int i = 0;
        while (i < activators.length) {
            if (!activators[i] && !disabled[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean allDeactivated(boolean[] disabled) {
        boolean[] blArray = disabled;
        int n = disabled.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (!b) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public double interpolateSQUAD(double[] input, double[] externalSquadWeights) throws BinaryBooleanFunction.InterpolationMethodNotSupported {
        double[] squadWeights = (double[])externalSquadWeights.clone();
        if (this.allDeactivated(this.disabled)) {
            return 0.0;
        }
        int i = 0;
        while (i < input.length) {
            if (this.disabled[i]) {
                input[i] = 0.0;
                squadWeights[i] = 0.0;
            }
            ++i;
        }
        double result = 0.0;
        if (this.onlyActivators(this.activators, this.disabled)) {
            double actsum = MathLib.dotProductUnchecked(this.activators, squadWeights, false);
            double actweight = MathLib.dotProductUnchecked(this.activators, squadWeights, input, false);
            result = (1.0 + actsum) / actsum * (actweight / (1.0 + actweight));
        } else if (this.onlyInhibitors(this.activators, this.disabled)) {
            double inhibitsum = MathLib.dotProductUnchecked(this.activators, squadWeights, true);
            double inhibitweight = MathLib.dotProductUnchecked(this.activators, squadWeights, input, true);
            result = 1.0 - (1.0 + inhibitsum) / inhibitsum * (inhibitweight / (1.0 + inhibitweight));
        } else {
            double actsum = MathLib.dotProductUnchecked(this.activators, squadWeights, false);
            double inhibitsum = MathLib.dotProductUnchecked(this.activators, squadWeights, true);
            double actweight = MathLib.dotProductUnchecked(this.activators, squadWeights, input, false);
            double inhibitweight = MathLib.dotProductUnchecked(this.activators, squadWeights, input, true);
            result = (1.0 + actsum) / actsum * (actweight / (1.0 + actweight));
            result *= 1.0 - (1.0 + inhibitsum) / inhibitsum * (inhibitweight / (1.0 + inhibitweight));
        }
        return result;
    }

    @Override
    public double interpolateBooleCube(double[] input) {
        return this.getTreeBooleanFunction().interpolateBooleCube(input);
    }

    private TreeBooleanFunction getTreeBooleanFunction() {
        return this.treeBooleanFunction;
    }

    @Override
    public ActivatorInhibitorFunction clone() {
        return new ActivatorInhibitorFunction((boolean[])this.activators.clone(), (boolean[])this.disabled.clone());
    }

    @Override
    protected BDD createBDDUnchecked(BDD[] inputs, BDDFactory bddFactory) {
        return this.getTreeBooleanFunction().createBDD(inputs, bddFactory);
    }

    @Override
    public String toString() {
        return this.getTreeBooleanFunction().toString();
    }

    @Override
    public void disableInput(int position) {
        this.disabled[position] = true;
        this.treeBooleanFunction.disableInput(position);
        this.wasMutated = true;
    }

    @Override
    public void restore() {
        if (!this.wasMutated) {
            return;
        }
        this.disabled = new boolean[this.disabled.length];
        this.treeBooleanFunction.restore();
    }

    @Override
    public String getFunctionString(String[] nodeNames, boolean odefyCompatible) {
        return this.getTreeBooleanFunction().getFunctionString(nodeNames, odefyCompatible);
    }

    public boolean[] getActivators() {
        return this.activators;
    }
}

