/*
 * Decompiled with CFR 0.152.
 */
package jimena.binarybf.treebf;

import java.util.LinkedList;
import jimena.binarybf.treebf.TreeNode;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class NotNode
extends TreeNode {
    private static final long serialVersionUID = 18801225881561981L;
    private TreeNode leaf;

    public NotNode(TreeNode leaf) {
        if (leaf == null) {
            throw new NullPointerException();
        }
        this.leaf = leaf;
        if (this.isCyclic()) {
            throw new IllegalArgumentException("The tree of a boolean function must be a acyclic.");
        }
    }

    public NotNode(TreeNode leaf, boolean disabled) {
        this(leaf);
        this.setDisabled(disabled);
    }

    @Override
    public double interpolateBooleCube(double[] inputs) {
        if (this.isDisabled()) {
            throw new ArithmeticException("A unary disabled node may not be evaluated.");
        }
        return 1.0 - this.leaf.interpolateBooleCube(inputs);
    }

    @Override
    public boolean eval(boolean[] inputs) {
        if (this.isDisabled()) {
            throw new ArithmeticException("A unary disabled node may not be evaluated.");
        }
        return !this.leaf.eval(inputs);
    }

    @Override
    public int getMinArity() {
        return this.leaf.getMinArity();
    }

    @Override
    protected boolean isCyclic(LinkedList<TreeNode> predecessors) {
        if (predecessors.contains(this)) {
            return true;
        }
        predecessors.add(this);
        boolean result = this.leaf.isCyclic(predecessors);
        predecessors.removeLast();
        return result;
    }

    @Override
    public NotNode clone() {
        return new NotNode(this.leaf.clone(), this.isDisabled());
    }

    @Override
    protected BDD createBDD(BDD[] inputs, BDDFactory bddFactory) {
        if (this.isDisabled()) {
            throw new ArithmeticException("A unary disabled node may not be evaluated.");
        }
        return this.leaf.createBDD(inputs, bddFactory).not();
    }

    @Override
    public String toString() {
        return "(NOT " + this.leaf.toString() + ")";
    }

    @Override
    public void disableInput(int position) {
        this.leaf.disableInput(position);
        this.setDisabled(this.leaf.isDisabled());
    }

    @Override
    public String getFunctionString(String[] nodeNames, boolean odefyCompatible) {
        if (this.isDisabled()) {
            throw new ArithmeticException("A unary disabled node may not be evaluated.");
        }
        return String.valueOf(odefyCompatible ? "(~" : "(NOT ") + this.leaf.getFunctionString(nodeNames, odefyCompatible) + ")";
    }
}

