/*
 * Decompiled with CFR 0.152.
 */
package jimena.binaryrn;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import jimena.binarybf.actinhibitf.ActivatorInhibitorFunction;
import jimena.binaryrn.Input;
import jimena.binaryrn.NetworkInput;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetworkLib;
import jimena.binaryrn.RegulatoryNetworkObserver;
import jimena.calculationparameters.SSSSearchParameters;
import jimena.calculationparameters.SSSSimulationParameters;
import jimena.calculationparameters.SimulationParameters;
import jimena.libs.BDDLib;
import jimena.libs.DoubleValue;
import jimena.libs.MathLib;
import jimena.libs.StandardNumberFormat;
import jimena.libs.StringLib;
import jimena.perturbation.OnOffPerturbation;
import jimena.simulation.CalculationController;
import jimena.simulation.SSSFromStartVector;
import jimena.simulation.SimulatedAnnealingSSS;
import jimena.simulation.Simulator;
import jimena.simulation.StableSteadyState;
import jimena.simulationmethods.SimulationMethod;
import jimena.ssssearcher.SSSSearchResult;
import jimena.ssssearcher.SSSSearcher;
import net.sf.javabdd.BDD;
import net.sf.javabdd.BDDFactory;

public class RegulatoryNetwork
implements Serializable {
    private static final long serialVersionUID = -3637940236128103506L;
    private NetworkNode[] networkNodes = new NetworkNode[0];
    private transient HashSet<RegulatoryNetworkObserver> observers = new HashSet();
    private DoubleValue timeIndex = new DoubleValue(0.0);

    private static void checkParameters(double stabilityMaxDiff, double stabilityMinTime, int simulationsPerInput, SimulationMethod method, double dt, double maxt) {
        if (stabilityMaxDiff < 0.0 || stabilityMinTime <= 0.0 || simulationsPerInput <= 0 || dt <= 0.0 || maxt <= 0.0) {
            throw new IllegalArgumentException();
        }
        if (method == null) {
            throw new NullPointerException();
        }
    }

    public RegulatoryNetwork() {
    }

    public RegulatoryNetwork(NetworkNode[] networkNodes, DoubleValue timeIndex) {
        if (networkNodes == null || timeIndex == null) {
            throw new NullPointerException();
        }
        this.networkNodes = networkNodes;
        this.observers = new HashSet();
        this.timeIndex = timeIndex;
    }

    public void addObserver(RegulatoryNetworkObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers.add(observer);
    }

    public SSSFromStartVector annealingStableSteadyStateSearcher(double[] startValues, SimulationMethod method, long maxt) {
        double[] dArray = startValues;
        int n = startValues.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            MathLib.checkNotNaNAndWithinRange(value, 0.0, 1.0);
            ++n2;
        }
        if (method == null) {
            throw new NullPointerException();
        }
        if (maxt <= 0L) {
            throw new IllegalArgumentException();
        }
        RegulatoryNetwork searchingNetwork = this.cloneClean();
        searchingNetwork.setValues(startValues);
        SimulatedAnnealingSSS stableSteadyState = new SimulatedAnnealingSSS(searchingNetwork, method, maxt);
        return stableSteadyState;
    }

    public RegulatoryNetwork cloneClean() {
        DoubleValue timeIndex = new DoubleValue(0.0);
        NetworkNode[] copiedNetworkNodes = new NetworkNode[this.nodeCount()];
        int i = 0;
        while (i < copiedNetworkNodes.length) {
            copiedNetworkNodes[i] = this.networkNodes[i].clone(timeIndex, false);
            ++i;
        }
        return new RegulatoryNetwork(copiedNetworkNodes, timeIndex);
    }

    public double cycleIndex(int node, boolean favorSmallCycles) {
        if (node < 0 || node > this.networkNodes.length) {
            throw new IllegalArgumentException("The specified node does not exist in the network.");
        }
        LinkedList<Integer> visitedNodes = new LinkedList<Integer>();
        visitedNodes.add(node);
        return this.cycleIndex(visitedNodes, node, favorSmallCycles);
    }

    private double cycleIndex(LinkedList<Integer> visitedNodes, int node, boolean favorSmallCycles) {
        double result = 0.0;
        for (Integer source : this.networkNodes[node].getInputSources()) {
            if (visitedNodes.peekFirst() == source) {
                if (favorSmallCycles) {
                    result += 1.0 / Math.pow(2.0, visitedNodes.size());
                    continue;
                }
                result += 1.0;
                continue;
            }
            if (visitedNodes.contains(source)) continue;
            visitedNodes.add(source);
            result += this.cycleIndex(visitedNodes, source, favorSmallCycles);
            visitedNodes.removeLast();
        }
        return result;
    }

    public double convergingTime(double stabilityMaxDiff, double stabilityMinTime, SimulationMethod method, double dt, double maxt, int simulations, int threads, boolean max) {
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, simulations, method, dt, maxt);
        ExecutorService threadPool = Executors.newFixedThreadPool(threads);
        StableSteadyState[] runs = new StableSteadyState[simulations];
        int i = 0;
        while (i < simulations) {
            double[] startValues = MathLib.randomVector(this.nodeCount());
            RegulatoryNetwork network = this.cloneClean();
            network.setValues(startValues);
            runs[i] = new StableSteadyState(network, method, dt, maxt, stabilityMaxDiff, stabilityMinTime, null);
            threadPool.submit(runs[i]);
            ++i;
        }
        threadPool.shutdown();
        try {
            threadPool.awaitTermination(240L, TimeUnit.HOURS);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        if (max) {
            double maximum = 0.0;
            int i2 = 0;
            while (i2 < simulations) {
                maximum = Math.max(maximum, runs[i2].getConvergingTime());
                ++i2;
            }
            return maximum;
        }
        double mean = 0.0;
        int i3 = 0;
        while (i3 < simulations) {
            mean += runs[i3].getConvergingTime();
            ++i3;
        }
        return mean / (double)simulations;
    }

    public void addNullMutation(int node, int input) {
        try {
            this.networkNodes[node].getInputs()[input].toString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("The specified input does not exist in the network.");
        }
        this.networkNodes[node].getFunction().disableInput(input);
    }

    public void addNullMutation(NetworkInput input) {
        this.addNullMutation(input.getNode(), input.getInput());
    }

    public void addNullMutation(List<NetworkInput> inputs) {
        for (NetworkInput input : inputs) {
            this.addNullMutation(input);
        }
    }

    public double deletionStabilityIndex(double stabilityMaxDiff, double stabilityMinTime, int simulationsPerInput, SimulationMethod method, double dt, double maxt, int changedNode, int changedInput, int minSuccesfulSimulations, int threads, boolean perturbateInputNodes) {
        try {
            this.networkNodes[changedNode].getInputs()[changedInput].toString();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("The specified input does not exist in the network.");
        }
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, simulationsPerInput, method, dt, maxt);
        if (minSuccesfulSimulations > simulationsPerInput) {
            throw new IllegalArgumentException("MinSuccesfulSimulations is greater than simulationsPerInput. The calculation cannot succeed.");
        }
        int countedResults = 0;
        double result = 0.0;
        ExecutorService threadPool = Executors.newFixedThreadPool(threads);
        StableSteadyState[] originalNetworkSSSS = new StableSteadyState[simulationsPerInput];
        StableSteadyState[] crippledNetworkSSSS = new StableSteadyState[simulationsPerInput];
        RegulatoryNetwork crippledNetworkTemplate = this.cloneClean();
        crippledNetworkTemplate.addNullMutation(changedNode, changedInput);
        int i = 0;
        while (i < simulationsPerInput) {
            double[] startValues = MathLib.randomVector(this.nodeCount());
            RegulatoryNetwork originalNetwork = this.cloneClean();
            int j = 0;
            while (j < originalNetwork.nodeCount()) {
                originalNetwork.getNetworkNodes()[j].getPerturbations().clear();
                if (perturbateInputNodes && originalNetwork.getNetworkNodes()[j].getInputs().length == 0) {
                    originalNetwork.getNetworkNodes()[j].getPerturbations().add(new OnOffPerturbation(startValues[j]));
                }
                ++j;
            }
            originalNetwork.setValues(startValues);
            originalNetworkSSSS[i] = new StableSteadyState(originalNetwork, method, dt, maxt, stabilityMaxDiff, stabilityMinTime, null);
            threadPool.submit(originalNetworkSSSS[i]);
            RegulatoryNetwork crippledNetwork = crippledNetworkTemplate.cloneClean();
            int j2 = 0;
            while (j2 < crippledNetwork.nodeCount() - 1) {
                crippledNetwork.getNetworkNodes()[j2].getPerturbations().clear();
                if (perturbateInputNodes && crippledNetwork.getNetworkNodes()[j2].getInputs().length == 0) {
                    crippledNetwork.getNetworkNodes()[j2].getPerturbations().add(new OnOffPerturbation(startValues[j2]));
                }
                ++j2;
            }
            crippledNetwork.setValues(startValues);
            crippledNetworkSSSS[i] = new StableSteadyState(crippledNetwork, method, dt, maxt, stabilityMaxDiff, stabilityMinTime, null);
            threadPool.submit(crippledNetworkSSSS[i]);
            ++i;
        }
        threadPool.shutdown();
        try {
            threadPool.awaitTermination(240L, TimeUnit.HOURS);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        i = 0;
        while (i < simulationsPerInput) {
            double[] originalResult = originalNetworkSSSS[i].getResult();
            double[] crippledResult = crippledNetworkSSSS[i].getResult();
            if (originalResult != null && crippledResult != null) {
                ++countedResults;
                result += MathLib.meanSquaredDifferenceUnchecked(originalResult, crippledResult);
            }
            ++i;
        }
        if (countedResults == 0) {
            return Double.NaN;
        }
        if (countedResults < minSuccesfulSimulations) {
            return Double.NaN;
        }
        return result / (double)countedResults;
    }

    public synchronized ArrayList<byte[]> discreteStableSteadyStates() {
        BDDFactory bddFactory = BDDLib.getBDDFactory();
        bddFactory.setVarNum(this.nodeCount());
        BDD[] nodes = new BDD[this.nodeCount()];
        int i = 0;
        while (i < this.nodeCount()) {
            nodes[i] = bddFactory.ithVar(i);
            ++i;
        }
        BDD network = bddFactory.one();
        int i2 = 0;
        while (i2 < this.nodeCount()) {
            BDD[] inputs = new BDD[this.networkNodes[i2].getInputs().length];
            int j = 0;
            while (j < this.networkNodes[i2].getInputs().length) {
                inputs[j] = nodes[this.networkNodes[i2].getInputs()[j].getSource()];
                ++j;
            }
            BDD functionBDD = this.networkNodes[i2].getFunction().createBDD(inputs, bddFactory);
            functionBDD = nodes[i2].biimp(functionBDD);
            network.andWith(functionBDD);
            ++i2;
        }
        return MathLib.bddAllsatResultToArray(network.allsat());
    }

    public String getFunctionString(int node) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified node is not valid.");
        }
        String[] nodeNames = this.getNodeNames();
        String[] inputNodeNames = new String[this.networkNodes[node].getInputs().length];
        int j = 0;
        while (j < this.networkNodes[node].getInputs().length) {
            inputNodeNames[j] = nodeNames[this.networkNodes[node].getInputs()[j].getSource()];
            ++j;
        }
        return String.valueOf(this.networkNodes[node].getName()) + " = " + this.networkNodes[node].getFunction().getFunctionString(inputNodeNames, false);
    }

    public String getFunctionStringOdefyCompatible(int node) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified node is not valid.");
        }
        String[] nodeNames = this.getNodeNames();
        String[] inputNodeNames = new String[this.networkNodes[node].getInputs().length];
        int j = 0;
        while (j < this.networkNodes[node].getInputs().length) {
            inputNodeNames[j] = nodeNames[this.networkNodes[node].getInputs()[j].getSource()];
            ++j;
        }
        return "'" + this.networkNodes[node].getName() + " = " + this.networkNodes[node].getFunction().getFunctionString(inputNodeNames, true) + "'";
    }

    public String getNetworkStringOdefyCompatible() {
        String result = "expr = {";
        int i = 0;
        while (i < this.networkNodes.length) {
            result = String.valueOf(result) + "\n" + this.getFunctionStringOdefyCompatible(i);
            if (i != this.networkNodes.length - 1) {
                result = String.valueOf(result) + ", ";
            }
            ++i;
        }
        result = String.valueOf(result) + "}";
        return result;
    }

    public String getNetworkString() {
        String result = new String();
        int i = 0;
        while (i < this.networkNodes.length) {
            result = String.valueOf(result) + "\n" + this.getFunctionString(i);
            ++i;
        }
        return result;
    }

    public void printNetwork() {
        System.out.println(this.getNetworkStringOdefyCompatible());
    }

    public TreeSet<Integer> getInputIndicesByName(int node, String name) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node was not found in the network.");
        }
        if (name == null) {
            throw new NullPointerException();
        }
        TreeSet<Integer> result = new TreeSet<Integer>();
        int i = 0;
        while (i < this.networkNodes[node].getInputs().length) {
            if (StringLib.equalsTrimmed(this.getInputSourceName(node, i), name)) {
                result.add(i);
            }
            ++i;
        }
        return result;
    }

    public TreeSet<Integer> getInputIndicesByName(String node, String input) {
        return this.getInputIndicesByName(this.getNodeIndexByName(node), input);
    }

    public String getInputSourceName(int node, int index) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node was not found in the network.");
        }
        if (node < 0 || index >= this.networkNodes[node].getInputs().length) {
            throw new IllegalArgumentException("The specified input was not found in the node.");
        }
        return this.networkNodes[this.networkNodes[node].getInputs()[index].getSource()].getName();
    }

    public NetworkNode[] getNetworkNodes() {
        return this.networkNodes;
    }

    public void setNetworkNodes(NetworkNode[] networkNodes) {
        this.networkNodes = networkNodes;
    }

    public NetworkNode getNodeByName(String name) {
        return this.networkNodes[this.getNodeIndexByName(name)];
    }

    public int getNodeIndexByName(String name) {
        int i = 0;
        while (i < this.networkNodes.length) {
            if (StringLib.equalsTrimmed(this.networkNodes[i].getName(), name)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Node not found.");
    }

    public String[] getNodeNames() {
        String[] names = new String[this.nodeCount()];
        int i = 0;
        while (i < this.nodeCount()) {
            names[i] = this.networkNodes[i].getName();
            ++i;
        }
        return names;
    }

    public HashSet<RegulatoryNetworkObserver> getObservers() {
        return this.observers;
    }

    public DoubleValue getTimeIndex() {
        return this.timeIndex;
    }

    public double[] getValues() {
        double[] result = new double[this.nodeCount()];
        int i = 0;
        while (i < this.nodeCount()) {
            result[i] = this.networkNodes[i].getValue();
            ++i;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.nodeCount() == 0;
    }

    public void loadNetwork(RegulatoryNetwork storedNetwork) {
        this.networkNodes = storedNetwork.getNetworkNodes();
        this.timeIndex = storedNetwork.getTimeIndex();
        this.notifyObserversOfChangedNetwork();
    }

    public void loadYEdFile(File file) {
        this.timeIndex = new DoubleValue(0.0);
        try {
            this.networkNodes = RegulatoryNetworkLib.parseYEdFile(file, this.timeIndex);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        this.notifyObserversOfChangedNetwork();
    }

    public void log() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.log();
            ++n2;
        }
    }

    public void makeDiscrete() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.makeDiscrete();
            ++n2;
        }
    }

    public int nodeCount() {
        return this.networkNodes.length;
    }

    public void notifyObserversOfChangedNetwork() {
        for (RegulatoryNetworkObserver observer : this.observers) {
            observer.notifyNetworkChanged();
        }
    }

    public void notifyObserversOfChangedValues() {
        for (RegulatoryNetworkObserver observer : this.observers) {
            observer.notifyValuesChanged();
        }
    }

    public void removeAllPerturbations() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.getPerturbations().clear();
            ++n2;
        }
    }

    public void removeObserver(RegulatoryNetworkObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers.remove(observer);
    }

    public void reset() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.reset();
            node.resetLog();
            ++n2;
        }
        this.timeIndex.setValue(0.0);
        this.notifyObserversOfChangedValues();
    }

    public void setObservers(HashSet<RegulatoryNetworkObserver> observers) {
        if (observers == null) {
            throw new NullPointerException();
        }
        this.observers = observers;
    }

    public void setValues(double[] values) {
        int i = 0;
        while (i < values.length) {
            this.networkNodes[i].setValue(values[i]);
            ++i;
        }
    }

    public void simulate(SimulationMethod method, double dt, double maxT, double maxSpeed, double minSimulationTimeBetweenLogs, CalculationController calculationController) {
        this.simulate(new SimulationParameters(method, dt, maxT, calculationController), maxSpeed, minSimulationTimeBetweenLogs);
    }

    public void simulate(SimulationParameters parameters, double maxSpeed, double minSimulationTimeBetweenLogs) {
        Simulator simulator = new Simulator(parameters, this, maxSpeed, minSimulationTimeBetweenLogs);
        simulator.start();
        try {
            simulator.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public double[] stableSteadyState(double[] startValues, double stabilityMaxDiff, double stabilityMinTime, SimulationMethod method, double dt, double maxt, CalculationController calculationController) {
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, 1, method, dt, maxt);
        double[] dArray = startValues;
        int n = startValues.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            MathLib.checkNotNaNAndWithinRange(value, 0.0, 1.0);
            ++n2;
        }
        StableSteadyState stableSteadyState = this.stableSteadyStateSearcher(startValues, stabilityMaxDiff, stabilityMinTime, method, dt, maxt, calculationController);
        Thread stableSteadyStateThread = new Thread(stableSteadyState);
        stableSteadyStateThread.start();
        try {
            stableSteadyStateThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return stableSteadyState.getResult();
    }

    public double[] stableSteadyState(double[] startValues, SSSSimulationParameters p) {
        return this.stableSteadyState(startValues, p.getStabilityMaxDiff(), p.getStabilityMinTime(), p.getMethod(), p.getDt(), p.getMaxT(), p.getCalculationController());
    }

    public ArrayList<double[]> stableSteadyStates(double stabilityMaxDiff, double stabilityMinTime, SimulationMethod method, double dt, double maxT, double duplicateMaxDiff, long maxTime, CalculationController calculationController, int threads, SSSSearcher sssSearcher) {
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, 1, method, dt, maxT);
        if (duplicateMaxDiff < 0.0 || maxTime <= 0L) {
            throw new IllegalArgumentException();
        }
        return this.stableSteadyStates(new SSSSearchParameters(method, dt, maxT, calculationController, stabilityMaxDiff, stabilityMinTime, threads, duplicateMaxDiff), maxTime, sssSearcher);
    }

    public ArrayList<double[]> stableSteadyStates(SSSSearchParameters parameters, long maxTime, SSSSearcher sssSearcher) {
        return sssSearcher.searchSSStates(this, parameters, maxTime).getResults();
    }

    public ArrayList<double[]> stableSteadyStates(long numberOfStarts, SSSSearchParameters parameters, SSSSearcher sssSearcher) {
        return sssSearcher.searchSSStates(this, numberOfStarts, parameters).getResults();
    }

    public SSSSearchResult stableSteadyStatesWithCounter(long numberOfStarts, SSSSearchParameters parameters, SSSSearcher sssSearcher) {
        return sssSearcher.searchSSStates(this, numberOfStarts, parameters);
    }

    public StableSteadyState stableSteadyStateSearcher(double[] startValues, double stabilityMaxDiff, double stabilityMinTime, SimulationMethod method, double dt, double maxt, CalculationController calculationController) {
        RegulatoryNetwork.checkParameters(stabilityMaxDiff, stabilityMinTime, 1, method, dt, maxt);
        double[] dArray = startValues;
        int n = startValues.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            MathLib.checkNotNaNAndWithinRange(value, 0.0, 1.0);
            ++n2;
        }
        RegulatoryNetwork searchingNetwork = this.cloneClean();
        searchingNetwork.setValues(startValues);
        StableSteadyState stableSteadyState = new StableSteadyState(searchingNetwork, method, dt, maxt, stabilityMaxDiff, stabilityMinTime, calculationController);
        return stableSteadyState;
    }

    public int sumOfInputs() {
        int numberOfInputs = 0;
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            numberOfInputs += node.getInputs().length;
            ++n2;
        }
        return numberOfInputs;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        double[] dArray = this.getValues();
        int n = dArray.length;
        int n2 = 0;
        while (n2 < n) {
            double o = dArray[n2];
            result.append(String.valueOf(StandardNumberFormat.SHORTFIXEDNUMBERFORMAT.format(o)) + " | ");
            ++n2;
        }
        return result.toString();
    }

    public NetworkInput getNextInput(int node, int input) {
        if (!this.isValidInput(node, input)) {
            throw new IllegalArgumentException("The specified input does not exist.(" + node + ", " + input + ")");
        }
        if (input + 1 >= this.networkNodes[node].getInputs().length) {
            int i = node + 1;
            while (i < this.networkNodes.length) {
                if (this.networkNodes[i].getInputs().length != 0) {
                    return new NetworkInput(i, 0);
                }
                ++i;
            }
            return null;
        }
        return new NetworkInput(node, input + 1);
    }

    public NetworkInput getNextInputWrap(int node, int input) {
        if (!this.isValidInput(node, input)) {
            throw new IllegalArgumentException("The specified input does not exist.(" + node + ", " + input + ")");
        }
        if (input + 1 >= this.networkNodes[node].getInputs().length) {
            int i = node + 1;
            while (i < this.networkNodes.length) {
                if (this.networkNodes[i].getInputs().length != 0) {
                    return new NetworkInput(i, 0);
                }
                ++i;
            }
            return this.getFirstInput();
        }
        return new NetworkInput(node, input + 1);
    }

    public NetworkInput getFirstInput() {
        int i = 0;
        while (i < this.networkNodes.length) {
            if (this.networkNodes[i].getInputs().length != 0) {
                return new NetworkInput(i, 0);
            }
            ++i;
        }
        return null;
    }

    public NetworkInput getNextInput(NetworkInput input) {
        return this.getNextInput(input.getNode(), input.getInput());
    }

    public NetworkInput getNextInputWrap(NetworkInput input) {
        return this.getNextInputWrap(input.getNode(), input.getInput());
    }

    public String getInputString(NetworkInput input, String sep) {
        return "\"" + this.networkNodes[this.networkNodes[input.getNode()].getInputs()[input.getInput()].getSource()].getName() + "\"" + sep + "\"" + this.networkNodes[input.getNode()].getName() + "\"";
    }

    public String getInputString(NetworkInput input) {
        return this.getInputString(input, "->");
    }

    public String getInputString(ArrayList<NetworkInput> inputs) {
        String result = "{ ";
        int i = 0;
        while (i < inputs.size() - 1) {
            result = String.valueOf(result) + this.getInputString(inputs.get(i)) + ", ";
            ++i;
        }
        if (inputs.size() != 0) {
            result = String.valueOf(result) + this.getInputString(inputs.get(inputs.size() - 1));
        }
        return String.valueOf(result) + " }";
    }

    public boolean isValidInput(NetworkInput input) {
        return this.isValidInput(input.getNode(), input.getInput());
    }

    public boolean isValidInput(int node, int input) {
        return node >= 0 && node < this.networkNodes.length && input >= 0 && input < this.networkNodes[node].getInputs().length;
    }

    public ArrayList<NetworkInput> getInputs() {
        ArrayList<NetworkInput> result = new ArrayList<NetworkInput>();
        if (this.getFirstInput() == null) {
            return result;
        }
        NetworkInput nextInput = this.getFirstInput();
        while (nextInput != null) {
            result.add(nextInput);
            nextInput = this.getNextInput(nextInput);
        }
        return result;
    }

    public ArrayList<NetworkInput> getInputsBySource(int fromNode) {
        if (fromNode < 0 || fromNode >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node " + fromNode + " was not found in the network.");
        }
        ArrayList<NetworkInput> result = new ArrayList<NetworkInput>();
        if (this.getFirstInput() == null) {
            return result;
        }
        NetworkInput nextInput = this.getFirstInput();
        while (nextInput != null) {
            if (this.networkNodes[nextInput.getNode()].getInputs()[nextInput.getInput()].getSource() != fromNode) {
                nextInput = this.getNextInput(nextInput);
                continue;
            }
            result.add(nextInput);
            nextInput = this.getNextInput(nextInput);
        }
        return result;
    }

    public ArrayList<NetworkInput> getInputsBySourceAndTarget(int fromNode, int toNode) {
        ArrayList<NetworkInput> result = new ArrayList<NetworkInput>();
        ArrayList<NetworkInput> from = this.getInputsBySource(fromNode);
        ArrayList<NetworkInput> to = this.getInputsByTarget(toNode);
        for (NetworkInput input : from) {
            if (!to.contains(input)) continue;
            result.add(input);
        }
        return result;
    }

    public ArrayList<NetworkInput> getInputsByTarget(int toNode) {
        if (toNode < 0 || toNode >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified network node was not found in the network.");
        }
        ArrayList<NetworkInput> result = new ArrayList<NetworkInput>();
        int i = 0;
        while (i < this.networkNodes[toNode].getInputs().length) {
            result.add(new NetworkInput(toNode, i));
            ++i;
        }
        return result;
    }

    public void restore() {
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            node.getFunction().restore();
            ++n2;
        }
    }

    public void printNetworkState() {
        int padding = StringLib.maxStringLength(this.getNodeNames());
        NetworkNode[] networkNodeArray = this.networkNodes;
        int n = this.networkNodes.length;
        int n2 = 0;
        while (n2 < n) {
            NetworkNode node = networkNodeArray[n2];
            System.out.println(String.valueOf(StringLib.padLeft(node.getName(), padding)) + ": " + node.getValue());
            ++n2;
        }
    }

    public String exportSQUAD() {
        String result = new String();
        int i = 0;
        while (i < this.networkNodes.length) {
            result = String.valueOf(result) + this.exportSQUAD(i);
            ++i;
        }
        return result;
    }

    public String exportSQUAD(int node) {
        if (node < 0 || node >= this.networkNodes.length) {
            throw new IllegalArgumentException("The specified node does not exist.");
        }
        String result = new String();
        if (this.networkNodes[node].getFunction() instanceof ActivatorInhibitorFunction) {
            boolean[] activators = ((ActivatorInhibitorFunction)this.networkNodes[node].getFunction()).getActivators();
            int i = 0;
            while (i < this.networkNodes[node].getInputs().length) {
                result = String.valueOf(result) + this.networkNodes[this.networkNodes[node].getInputs()[i].getSource()].getName() + (activators[i] ? " -> " : " -| ") + this.networkNodes[node].getName() + "\n";
                ++i;
            }
        } else {
            throw new IllegalArgumentException("The specified node is not an activator-inhibitor-node.");
        }
        return result;
    }

    public void switchInputs(NetworkInput input1, NetworkInput input2) {
        int temp = this.networkNodes[input1.getNode()].getInputs()[input1.getInput()].getSource();
        this.networkNodes[input1.getNode()].getInputs()[input1.getInput()].setSource(this.networkNodes[input2.getNode()].getInputs()[input2.getInput()].getSource());
        this.networkNodes[input2.getNode()].getInputs()[input2.getInput()].setSource(temp);
    }

    public void switchRandomInputs() {
        ArrayList<NetworkInput> inputs = this.getInputs();
        int rnd1 = (int)(Math.random() * (double)(inputs.size() - 1));
        int rnd2 = (int)(Math.random() * (double)(inputs.size() - 1));
        this.switchInputs(inputs.get(rnd1), inputs.get(rnd2));
    }

    public void switchRandomInputs(int repetitions) {
        int i = 0;
        while (i < repetitions) {
            this.switchRandomInputs();
            ++i;
        }
    }

    public int numberOfLoops() {
        int counter = 0;
        int i = 0;
        while (i < this.networkNodes.length) {
            int j = 0;
            while (j < this.networkNodes[i].getInputs().length) {
                if (this.networkNodes[i].getInputs()[j].getSource() == i) {
                    ++counter;
                }
                ++j;
            }
            ++i;
        }
        return counter;
    }

    public int numberOfInputNodes() {
        int counter = 0;
        int i = 0;
        while (i < this.networkNodes.length) {
            boolean isInput = true;
            int j = 0;
            while (j < this.networkNodes[i].getInputs().length) {
                if (this.networkNodes[i].getInputs()[j].getSource() != i) {
                    isInput = false;
                }
                ++j;
            }
            if (isInput) {
                ++counter;
            }
            ++i;
        }
        return counter;
    }

    public TreeSet<Integer> setOfAllNodeIndices() {
        TreeSet<Integer> allIndices = new TreeSet<Integer>();
        int i = 0;
        while (i < this.nodeCount()) {
            allIndices.add(i);
            ++i;
        }
        return allIndices;
    }

    public Input getInput(NetworkInput input) {
        return this.networkNodes[input.getNode()].getInputs()[input.getInput()];
    }
}

