/*
 * Decompiled with CFR 0.152.
 */
package jimena.libs;

import java.io.Serializable;
import jimena.libs.MathLib;
import jimena.libs.StandardNumberFormat;

public class DoubleValue
implements Serializable {
    private static final long serialVersionUID = 929173770778383082L;
    private double value;
    private double min;
    private double max;

    public DoubleValue(double value) {
        this(value, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public DoubleValue(double value, double min, double max) {
        this.min = min;
        this.max = max;
        this.setValue(value);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = MathLib.limitToRangeAndAssertNumerical(value, this.min, this.max);
    }

    public void addValue(Double addend) {
        this.setValue(this.value + addend);
    }

    public String toString() {
        return StandardNumberFormat.NUMBERFORMAT.format(this.value);
    }

    public DoubleValue clone() {
        return new DoubleValue(this.value, this.min, this.max);
    }
}

