/*
 * Decompiled with CFR 0.152.
 */
package jimena.perturbation;

import jimena.libs.DoubleValue;
import jimena.libs.MathLib;
import jimena.perturbation.Perturbation;
import jimena.perturbation.RealValuesPerturbation;

public class SinePerturbation
extends RealValuesPerturbation {
    private DoubleValue start;
    private DoubleValue end;
    private DoubleValue min;
    private DoubleValue max;
    private DoubleValue phase;
    private DoubleValue freq;
    private static final String[] valueNames = new String[]{"Start", "End", "Minimum", "Maximum", "Angular frequency", "Phase"};

    private SinePerturbation(DoubleValue start, DoubleValue end, DoubleValue min, DoubleValue max, DoubleValue freq, DoubleValue phase) {
        super(new DoubleValue[]{start, end, min, max, freq, phase}, valueNames);
        this.start = start;
        this.end = end;
        this.min = min;
        this.max = max;
        this.phase = phase;
        this.freq = freq;
    }

    public SinePerturbation(double start, double end, double min, double max, double freq, double phase) {
        this(new DoubleValue(MathLib.isNotNaN(start) ? start : 0.0), new DoubleValue(MathLib.isNotNaN(end) ? end : 1000.0), new DoubleValue(MathLib.isNotNaN(min) ? min : 0.0, 0.0, 1.0), new DoubleValue(MathLib.isNotNaN(max) ? max : 1.0, 0.0, 1.0), new DoubleValue(MathLib.isNotNaN(freq) ? freq : 10.0), new DoubleValue(MathLib.isNotNaN(phase) ? phase : 0.0));
    }

    public SinePerturbation(double start, double end, double min, double max) {
        this(start, end, min, max, Double.NaN, Double.NaN);
    }

    public SinePerturbation(double start, double min, double max) {
        this(start, Double.NaN, min, max, Double.NaN, Double.NaN);
    }

    public SinePerturbation(double min, double max) {
        this(Double.NaN, Double.NaN, min, max, Double.NaN, Double.NaN);
    }

    public SinePerturbation(double start) {
        this(start, Double.NaN, Double.NaN, Double.NaN, Double.NaN, Double.NaN);
    }

    public SinePerturbation() {
        this(0.0);
    }

    @Override
    public double getValue(double t) {
        if (t >= this.start.getValue() && t <= this.end.getValue()) {
            double value = 0.5 + 0.5 * Math.sin(t * this.freq.getValue() + this.phase.getValue());
            return this.min.getValue() + value * (this.max.getValue() - this.min.getValue());
        }
        return -1.0;
    }

    @Override
    public String getDescription() {
        return "Sine function proportional to sin(" + this.freq + "*t + " + this.phase + ") between " + this.min + " and " + this.max + " from " + this.start + " to " + this.end;
    }

    public String toString() {
        return "Sine Perturbation";
    }

    @Override
    public Perturbation clone() {
        return new SinePerturbation(this.start.getValue(), this.end.getValue(), this.min.getValue(), this.max.getValue(), this.freq.getValue(), this.phase.getValue());
    }
}

