/*
 * Decompiled with CFR 0.152.
 */
package jimena.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import jimena.settings.DoubleSetting;
import jimena.settings.IntegerSetting;
import jimena.settings.RawSetting;

public class SettingsWindow
extends JFrame {
    private static final long serialVersionUID = 371183139603442630L;
    private static ArrayList<RawSetting> settings = new ArrayList();
    public static final DoubleSetting MAXDUPLICATEDIFFERENCE = new DoubleSetting("maxduplicatediff", "Maximum difference between duplicates", null, 1.0E-5, 0.1, 0.002);
    public static final DoubleSetting MAXSTABILITYDIFFERENCE = new DoubleSetting("maxstabilitydiff", "Maximum deviation for a curve to be considered stable", null, 1.0E-5, 0.1, 0.001);
    public static final DoubleSetting MINSTABILITYTIME = new DoubleSetting("minstabilitytime", "Minimum time within the maximum deviation", null, 0.1, 1000.0, 5.0);
    public static final DoubleSetting MINSIMULATIONTIMEBETWEENLOGS = new DoubleSetting("minsimulationtimebetweenlogs", "Minimum (simulation) time between two log entries during the simulation", null, 1.0E-5, 1.0, 0.001);
    public static final IntegerSetting THREADS = new IntegerSetting("threads", "Maximum number of threads used in multithreaded calculations", null, 1, 256, Runtime.getRuntime().availableProcessors());

    protected static void registerSetting(RawSetting setting) {
        settings.add(setting);
    }

    public SettingsWindow() {
        this.setIconImage(new ImageIcon("images" + File.separator + "settings16.png").getImage());
        this.setTitle("Settings");
        this.getContentPane().setLayout(new BorderLayout());
        JPanel settingsPanel = new JPanel();
        settingsPanel.setLayout(new GridLayout(settings.size(), 1, 12, 12));
        this.getContentPane().add((Component)settingsPanel, "Center");
        for (RawSetting setting : settings) {
            JPanel settingPanel = new JPanel(new BorderLayout(10, 0));
            settingPanel.add((Component)new JLabel(setting.getLabel()), "Center");
            settingPanel.add((Component)setting.getTextField(), "East");
            settingsPanel.add(settingPanel);
        }
        settingsPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setLayout(new GridLayout(1, 2));
        JButton closeWindow = new JButton("Reset All");
        closeWindow.setToolTipText("You can save a value by clicking on another input box. Enter a invalid string to reset an input box to the default value.");
        closeWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (RawSetting setting : settings) {
                    setting.reset();
                }
            }
        });
        buttonsPanel.add(closeWindow);
        this.getContentPane().add((Component)buttonsPanel, "South");
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setDefaultCloseOperation(1);
        this.setResizable(false);
        this.pack();
    }
}

