/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import jimena.analysis.FunctionsAnalysis;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.customfunction.CustomFunction;
import jimena.simulation.BasicCalculationController;
import jimena.simulationmethods.SQUADMethod;

public class ExampleCustomFunction {
    public static void main(String[] args) throws Exception {
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File("C:\\Users\\Stefan\\Desktop\\testnet.graphml"));
        network.getNodeByName("A").setValue(1.0);
        network.getNodeByName("B").setValue(1.0);
        network.getNodeByName("C").setValue(1.0);
        network.getNodeByName("D").setValue(1.0);
        network.simulate(new SQUADMethod(), 1.0E-4, 10.0, Double.POSITIVE_INFINITY, 1.0, new BasicCalculationController());
        System.out.println("Result of the simulation of the unaltered network: " + network);
        double[] centralities = FunctionsAnalysis.totalCentralities(network, 500, new StandardConvergenceParameters(new SQUADMethod(), 0.02));
        System.out.println("Centralities of the unaltered network: " + Arrays.toString(centralities));
        network.getNodeByName("A").setValue(1.0);
        network.getNodeByName("B").setValue(1.0);
        network.getNodeByName("C").setValue(1.0);
        network.getNodeByName("D").setValue(1.0);
        CustomFunction customFunctionNodeC = new CustomFunction(){

            @Override
            public double eval(HashMap<String, Double> inputs) {
                return inputs.get("A") * inputs.get("C");
            }
        };
        network.getNodeByName("C").setCustomFunction(customFunctionNodeC);
        network.simulate(new SQUADMethod(), 1.0E-4, 10.0, Double.POSITIVE_INFINITY, 1.0, new BasicCalculationController());
        System.out.println("Result of the simulation of the altered network: " + network);
        centralities = FunctionsAnalysis.totalCentralities(network, 500, new StandardConvergenceParameters(new SQUADMethod(), 0.02));
        System.out.println("Centralities of the altered network: " + Arrays.toString(centralities));
    }
}

