/*
 * Decompiled with CFR 0.152.
 */
package jimena.gui.guilib;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import jimena.gui.guilib.DataTableModel;
import jimena.gui.main.Main;
import jimena.libs.StringLib;
import jimena.libs.TxtFileChooser;
import jimena.solver.SolverFrame;

public class TableFrame
extends JDialog {
    private static final long serialVersionUID = 6543306651498035545L;
    private JTable table = null;
    private String[] titles = null;
    private TableModel model = null;
    private File currentFile = null;

    private String getExportString() {
        int i;
        ArrayList<Object[]> exportData = new ArrayList<Object[]>();
        Object[] header = new Object[this.model.getColumnCount()];
        int j = 0;
        while (j < this.model.getColumnCount()) {
            header[j] = this.model.getColumnName(j);
            ++j;
        }
        exportData.add(header);
        if (this.table.getSelectedRowCount() != 0) {
            int[] nArray = this.table.getSelectedRows();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                i = nArray[n2];
                Object[] row = new Object[this.model.getColumnCount()];
                int j2 = 0;
                while (j2 < this.model.getColumnCount()) {
                    row[j2] = this.model.getValueAt(i, j2);
                    ++j2;
                }
                exportData.add(row);
                ++n2;
            }
        } else {
            i = 0;
            while (i < this.table.getRowCount()) {
                Object[] row = new Object[this.model.getColumnCount()];
                int j3 = 0;
                while (j3 < this.model.getColumnCount()) {
                    row[j3] = this.model.getValueAt(i, j3);
                    ++j3;
                }
                exportData.add(row);
                ++i;
            }
        }
        return StringLib.arrayToTabSeparatedUnchecked(exportData);
    }

    private void runSolverEvent() {
        JFrame f = null;
        try {
            f = new SolverFrame(this.getExportString(), this.model, this.currentFile);
        }
        catch (NumberFormatException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        f.setDefaultCloseOperation(2);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        f.pack();
        f.setLocationRelativeTo(null);
        f.setVisible(true);
    }

    private void exportToFile() {
        TxtFileChooser.writeToTextFile(this.getExportString(), this);
    }

    private void exportToClipboard() {
        StringLib.writeToClipboard(this.getExportString());
    }

    public TableFrame(JFrame parent, String title, ArrayList<Object[]> data, String[] titles, Class<?> type, String[] horizontal) {
        this(parent, title, data, titles, type, horizontal, Main.currentFile);
    }

    public TableFrame(JFrame parent, String title, ArrayList<Object[]> data, String[] titles, Class<?> type, String[] horizontal, File currentFile) {
        super(parent, String.valueOf(title) + " - Ctrl+C to copy a line - Export the data for better accuracy", false);
        this.currentFile = currentFile;
        this.titles = titles;
        this.getContentPane().setLayout(new BorderLayout());
        this.model = new DataTableModel(data, titles, type, horizontal);
        this.table = new JTable(this.model){
            private static final long serialVersionUID = -7707184520358542400L;
            {
                KeyListener[] keyListenerArray = this.getKeyListeners();
                int n = keyListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    KeyListener listener = keyListenerArray[n2];
                    this.removeKeyListener(listener);
                    ++n2;
                }
                this.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 83 && e.isControlDown()) {
                            TableFrame.this.exportToFile();
                        } else if (e.getKeyCode() == 65 && e.isControlDown()) {
                            TableFrame.this.exportToClipboard();
                        }
                    }
                });
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }
        };
        DefaultTableColumnModel columnModel = (DefaultTableColumnModel)this.table.getColumnModel();
        int i = 0;
        while (i < columnModel.getColumnCount()) {
            columnModel.getColumn(i).setPreferredWidth(50);
            ++i;
        }
        this.table.setTableHeader(new JTableHeader(this.table.getColumnModel()){
            private static final long serialVersionUID = -8257137320637006229L;

            @Override
            public String getToolTipText(MouseEvent e) {
                int i = TableFrame.this.table.getColumnModel().getColumnIndexAtX(e.getX());
                return TableFrame.this.titles[i];
            }
        });
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setToolTipText("Select several row using the shift and control keys and save the values to a csv file by pressing Ctrl + [S].");
        this.table.setDefaultRenderer(Double.class, new FractionCellRenderer(5));
        this.getContentPane().add((Component)new JScrollPane(this.table), "Center");
        JPanel controlPanel = new JPanel(new GridLayout(1, 3));
        JButton closeButton = new JButton("Close Window");
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableFrame.this.setVisible(false);
            }
        });
        controlPanel.add(closeButton);
        JButton exportFile = new JButton("Export to File");
        exportFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableFrame.this.exportToFile();
            }
        });
        controlPanel.add(exportFile);
        JButton runAnalyzer = new JButton("Switch Analyzer (data-driven method)");
        runAnalyzer.setIcon(new ImageIcon("images" + File.separator + "chart16.png"));
        runAnalyzer.setForeground(this.getForeground().darker());
        runAnalyzer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableFrame.this.runSolverEvent();
            }
        });
        controlPanel.add(runAnalyzer);
        JButton exportClipboard = new JButton("Export to Clipboard");
        exportClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TableFrame.this.exportToClipboard();
            }
        });
        controlPanel.add(exportClipboard);
        this.getContentPane().add((Component)controlPanel, "South");
        this.pack();
        this.getRootPane().setDefaultButton(closeButton);
        this.setDefaultCloseOperation(2);
    }

    class FractionCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 4206747185037314310L;
        private final int fraction;
        private final NumberFormat formatter = NumberFormat.getInstance();

        public FractionCellRenderer(int fraction) {
            this.fraction = fraction;
            this.setHorizontalAlignment(4);
        }

        @Override
        protected void setValue(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            if (!(value instanceof Double)) {
                throw new IllegalArgumentException("This rendere only works with doubles.");
            }
            this.formatter.setMaximumFractionDigits(this.fraction);
            this.setText(this.formatter.format(((Number)value).doubleValue()));
        }
    }
}

