/*
 * Decompiled with CFR 0.152.
 */
package jimena.simulationmethods;

import jimena.binarybf.BinaryBooleanFunction;
import jimena.binaryrn.NetworkNode;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.libs.MathLib;
import jimena.simulationmethods.DiscreteSimulationMethod;
import jimena.simulationmethods.SimulationMethod;

public class ARBNMethod
extends DiscreteSimulationMethod {
    @Override
    public void stepValuesOnly(RegulatoryNetwork network, double dt) {
        int i = MathLib.getRandom().nextInt(network.size());
        NetworkNode node = network.getNetworkNodes()[i];
        BinaryBooleanFunction function = node.getFunction();
        network.getNetworkNodes()[i].setValue(function.eval(this.getBooleanInputs(network, i)) ? 1.0 : 0.0);
    }

    @Override
    public String toString() {
        return "ARBN";
    }

    @Override
    public SimulationMethod clone() {
        return new ARBNMethod();
    }
}

