function [ J ] = get_J( u,f,xd,OCP )
%Calculates the value of the target functional
%J=0.5*sum_i(int((x(i)-xd(i))^2))+alpha*sum_j(int(u(j))) for a given
%u, details see main Variables
%right hand-side f of the ordinary differential equation
%dx(t)/dt=f(x(t),u(t)) and desired state xd, details see main.m Variables

dt=OCP.timeInterval;
x=forward(f,u,OCP);                                     %Calculate state x
J=0.5*dt*sum(sum((x-xd).^2))+dt*OCP.alpha*sum(sum(u));  %Calculate target functional 0.5*sum_i^n(||x_i-xd_d||^2)+alpha*sum_i^m(||u_i||_L^1)

end

