function [ xd ] = get_xd(finalState,OCP)
%get_xd creates a matrix in whose row i the the final value of the
%corresponding node i is given as a constant function over time with value
%finalState(i)
%Input: 1 x numNodes row vector finalState, struct OCP

Nt=round(OCP.timeHorizon/OCP.timeInterval);         %Number of time steps

for i=1:OCP.numNodes
    xd(i,:)=finalState(1,i)*ones(1,Nt+1);
end
end

