/*
 * Decompiled with CFR 0.152.
 */
package diss;

import java.io.File;
import jimena.analysis.FunctionsAnalysis;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.libs.MathLib;
import jimena.simulationmethods.SQUADMethod;

public class Clustering {
    public static void main(String[] args) {
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File("K:\\realnetworks\\Th\\Th 2010 Version corrected layouted loops.graphml"));
        StandardConvergenceParameters parameters = new StandardConvergenceParameters(new SQUADMethod(), 0.05);
        int simulations = 200;
        String[] stringArray = network.getNodeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            System.out.print("\"" + name + "\",");
            ++n2;
        }
        System.out.println();
        System.out.println();
        double[][] matrixTC = null;
        try {
            matrixTC = FunctionsAnalysis.valueCentralityMatrix(network, simulations, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Clustering.printMatrix(matrixTC);
        double[][] matrixTCnormalized = new double[matrixTC.length][matrixTC[0].length];
        int i = 0;
        while (i < matrixTC.length) {
            int j = 0;
            while (j < matrixTC[0].length) {
                matrixTCnormalized[i][j] = matrixTC[i][j] / MathLib.sum(matrixTC[i]);
                ++j;
            }
            ++i;
        }
        Clustering.printMatrix(matrixTCnormalized);
    }

    public static String math(double input) {
        return String.valueOf(input).replaceAll("E", "\\*^");
    }

    public static void printMatrix(double[][] matrix) {
        System.out.print("{");
        int i = 0;
        while (i < matrix.length) {
            System.out.print("{");
            int j = 0;
            while (j < matrix[0].length) {
                System.out.print(Clustering.math(matrix[i][j]));
                if (j != matrix[0].length - 1) {
                    System.out.print(",");
                }
                ++j;
            }
            System.out.print("}");
            if (i != matrix.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
        System.out.println("}");
    }
}

