/*
 * Decompiled with CFR 0.152.
 */
package diss;

import java.io.File;
import jimena.analysis2.CoopDirectionalValueCentrality;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.simulationmethods.SQUADMethod;

public class CoopVCSingle {
    public static void main(String[] args) throws Exception {
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File("K:\\realnetworks\\Th\\Th 2010 Version corrected layouted loops.graphml"));
        StandardConvergenceParameters parameters = new StandardConvergenceParameters(new SQUADMethod(), 0.06);
        int simulations = 10000;
        String[] stringArray = network.getNodeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            System.out.print(String.valueOf(s) + "\t");
            ++n2;
        }
        System.out.println();
        int node1 = network.getNodeIndexByName("IFNg");
        int node2 = network.getNodeIndexByName("IL4");
        int i = 0;
        while (i < 10) {
            System.out.print("1\t");
            CoopVCSingle.printArray(CoopDirectionalValueCentrality.valueCentralityVector(network, simulations, parameters, node1));
            System.out.print("2\t");
            CoopVCSingle.printArray(CoopDirectionalValueCentrality.valueCentralityVector(network, simulations, parameters, node2));
            System.out.print("3\t");
            CoopVCSingle.printArray(CoopDirectionalValueCentrality.valueCentralityVector(network, simulations, parameters, node1, node2));
            ++i;
        }
    }

    public static void printArray(double[] values) {
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            System.out.print(String.valueOf(d) + "\t");
            ++n2;
        }
        System.out.println();
    }
}

