/*
 * Decompiled with CFR 0.152.
 */
package diss;

import java.io.File;
import java.util.ArrayList;
import jimena.analysis2.Cooperativity;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.ConvergenceParameters;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.simulationmethods.SQUADMethod;

public class CooperativitySingleNodes {
    public static void main(String[] args) {
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File("K:\\realnetworks\\Th\\Th 2010 Version corrected layouted loops.graphml"));
        StandardConvergenceParameters parameters = new StandardConvergenceParameters(new SQUADMethod(), 0.05);
        int simulations = 2000;
        ArrayList<int[]> pairs = new ArrayList<int[]>();
        pairs.add(new int[]{network.getNodeIndexByName("IFNg"), network.getNodeIndexByName("IL4")});
        for (int[] pair : pairs) {
            int z = 0;
            while (z < 100) {
                int i = pair[0];
                int j = pair[1];
                double vcNode1 = 0.0;
                double vcNode2 = 0.0;
                double coop = 0.0;
                double coopCoupled = 0.0;
                try {
                    coop = Cooperativity.valueCentrality(network, simulations, (ConvergenceParameters)parameters, false, i, j);
                    coopCoupled = Cooperativity.valueCentrality(network, simulations, (ConvergenceParameters)parameters, true, i, j);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println(String.valueOf(i) + "\t" + network.getNodeNames()[i] + "\t" + j + "\t" + network.getNodeNames()[j] + "\t" + vcNode1 + "\t" + vcNode2 + "\t" + coop + "\t" + coopCoupled);
                ++z;
            }
        }
    }
}

