/*
 * Decompiled with CFR 0.152.
 */
package diss;

import java.io.File;
import jimena.analysis2.DirectionalValueCentrality;
import jimena.binaryrn.RegulatoryNetwork;
import jimena.calculationparameters.StandardConvergenceParameters;
import jimena.libs.MathLib;
import jimena.simulationmethods.SQUADMethod;

public class DirectionalVC {
    public static void main(String[] args) {
        RegulatoryNetwork network = new RegulatoryNetwork();
        network.loadYEdFile(new File("K:\\diss\\Figures\\Methods\\cooperativity.graphml"));
        StandardConvergenceParameters parameters = new StandardConvergenceParameters(new SQUADMethod(), 0.05);
        int simulations = 30000;
        String[] stringArray = network.getNodeNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            System.out.print("\"" + name + "\",");
            ++n2;
        }
        System.out.println();
        double[][] matrix = null;
        try {
            matrix = DirectionalValueCentrality.valueCentralityMatrix(network, simulations, parameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DirectionalVC.printMatrix(matrix);
        int i = 0;
        while (i < matrix.length) {
            matrix[i] = MathLib.normalizeCentralities(matrix[i]);
            ++i;
        }
        DirectionalVC.printMatrix(matrix);
        double[][] distanceMatrix = new double[matrix.length][matrix[0].length];
        int i2 = 0;
        while (i2 < matrix.length) {
            int j = 0;
            while (j < matrix[0].length) {
                distanceMatrix[i2][j] = 1.0 - DirectionalVC.correlation(matrix[i2], matrix[j]);
                ++j;
            }
            ++i2;
        }
        DirectionalVC.printMatrix(distanceMatrix);
    }

    public static double correlation(double[] p, double[] q) {
        double sumP = 0.0;
        double sumQ = 0.0;
        double sumPSquared = 0.0;
        double sumQSquared = 0.0;
        double sumPQ = 0.0;
        int i = 0;
        while (i < p.length) {
            sumP += p[i];
            sumQ += q[i];
            sumPSquared += p[i] * p[i];
            sumQSquared += q[i] * q[i];
            sumPQ += p[i] * q[i];
            ++i;
        }
        double r = ((double)p.length * sumPQ - sumP * sumQ) / Math.sqrt(((double)p.length * sumPSquared - sumP * sumP) * ((double)p.length * sumQSquared - sumQ * sumQ));
        return r;
    }

    public static void printMatrix(double[][] matrix) {
        System.out.print("{");
        int i = 0;
        while (i < matrix.length) {
            System.out.print("{");
            int j = 0;
            while (j < matrix[0].length) {
                System.out.print(DirectionalVC.math(matrix[i][j]));
                if (j != matrix[0].length - 1) {
                    System.out.print(",");
                }
                ++j;
            }
            System.out.print("}");
            if (i != matrix.length - 1) {
                System.out.print(",");
            }
            ++i;
        }
        System.out.println("}");
    }

    public static String math(double input) {
        return String.valueOf(input).replaceAll("E", "\\*^");
    }
}

